/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.List;
import java.util.Optional;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.entity.ValidationLevel;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;

public final class OptionalDecoder
implements Decoder<Optional<?>> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Optional";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return Optional.class.isAssignableFrom(type.getRawType());
    }

    @Override
    public GResultOf<Optional<?>> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        if (node != null) {
            GResultOf<?> optionalValue = decoderContext.getDecoderService().decodeNode(path, tags, node, type.getFirstParameterType(), decoderContext);
            if (optionalValue.hasResults()) {
                return GResultOf.resultOf(Optional.of(optionalValue.results()), optionalValue.getErrors());
            }
            List<ValidationError> errors = optionalValue.getErrorsNotLevel(ValidationLevel.MISSING_VALUE);
            errors.add(new ValidationError.OptionalMissingValueDecoding(path, node, this.name(), decoderContext));
            return GResultOf.resultOf(Optional.ofNullable(optionalValue.results()), errors);
        }
        return GResultOf.resultOf(Optional.empty(), new ValidationError.OptionalMissingValueDecoding(path, this.name(), decoderContext));
    }
}

