/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.OptionalDouble;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;

public final class OptionalDoubleDecoder
implements Decoder<OptionalDouble> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "OptionalDouble";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return OptionalDouble.class.isAssignableFrom(type.getRawType());
    }

    @Override
    public GResultOf<OptionalDouble> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        if (node instanceof LeafNode && node.getValue().isPresent()) {
            GResultOf<Double> optionalValue = decoderContext.getDecoderService().decodeNode(path, tags, node, TypeCapture.of(Double.class), decoderContext);
            if (optionalValue.hasResults()) {
                return GResultOf.resultOf(OptionalDouble.of(optionalValue.results()), optionalValue.getErrors());
            }
            return GResultOf.resultOf(OptionalDouble.empty(), optionalValue.getErrors());
        }
        return GResultOf.resultOf(OptionalDouble.empty(), new ValidationError.OptionalMissingValueDecoding(path, node, this.name(), decoderContext));
    }
}

