/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.OptionalInt;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;

public final class OptionalIntDecoder
implements Decoder<OptionalInt> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "OptionalInt";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return OptionalInt.class.isAssignableFrom(type.getRawType());
    }

    @Override
    public GResultOf<OptionalInt> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        if (node instanceof LeafNode && node.getValue().isPresent()) {
            GResultOf<Integer> optionalValue = decoderContext.getDecoderService().decodeNode(path, tags, node, TypeCapture.of(Integer.class), decoderContext);
            if (optionalValue.hasResults()) {
                return GResultOf.resultOf(OptionalInt.of(optionalValue.results()), optionalValue.getErrors());
            }
            return GResultOf.resultOf(OptionalInt.empty(), optionalValue.getErrors());
        }
        return GResultOf.resultOf(OptionalInt.empty(), new ValidationError.OptionalMissingValueDecoding(path, node, this.name(), decoderContext));
    }
}

