/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.OptionalLong;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;

public final class OptionalLongDecoder
implements Decoder<OptionalLong> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "OptionalLong";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return OptionalLong.class.isAssignableFrom(type.getRawType());
    }

    @Override
    public GResultOf<OptionalLong> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        if (node instanceof LeafNode && node.getValue().isPresent()) {
            GResultOf<Long> optionalValue = decoderContext.getDecoderService().decodeNode(path, tags, node, TypeCapture.of(Long.class), decoderContext);
            if (optionalValue.hasResults()) {
                return GResultOf.resultOf(OptionalLong.of(optionalValue.results()), optionalValue.getErrors());
            }
            return GResultOf.resultOf(OptionalLong.empty(), optionalValue.getErrors());
        }
        return GResultOf.resultOf(OptionalLong.empty(), new ValidationError.OptionalMissingValueDecoding(path, node, this.name(), decoderContext));
    }
}

