/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.github.gestalt.config.annotations.Config;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.DecoderService;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.decoder.ProxyDecoderMode;
import org.github.gestalt.config.entity.GestaltConfig;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.entity.ValidationLevel;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.reload.CoreReloadListener;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.ClassUtils;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.Pair;
import org.github.gestalt.config.utils.PathUtil;

public final class ProxyDecoder
implements Decoder<Object> {
    private ProxyDecoderMode proxyDecoderMode = ProxyDecoderMode.CACHE;
    private GestaltConfig config;

    private static String getConfigNameFromMethod(String methodName, Type returnType) {
        String name = methodName;
        if (methodName.startsWith("get")) {
            name = methodName.substring(3);
        } else if (methodName.startsWith("is") && (returnType.equals(Boolean.TYPE) || returnType.equals(Boolean.TYPE))) {
            name = methodName.substring(2);
        }
        char[] nameArray = name.toCharArray();
        nameArray[0] = Character.toLowerCase(nameArray[0]);
        return new String(nameArray);
    }

    @Override
    public void applyConfig(GestaltConfig config) {
        this.proxyDecoderMode = config.getProxyDecoderMode();
        this.config = config;
    }

    @Override
    public Priority priority() {
        return Priority.LOW;
    }

    @Override
    public String name() {
        return "proxy";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return type.isInterface() && !Collection.class.isAssignableFrom(type.getRawType()) && !Map.class.isAssignableFrom(type.getRawType());
    }

    @Override
    public GResultOf<Object> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        ProxyPassThroughInvocationHandler proxyHandler;
        if (!(node instanceof MapNode)) {
            return GResultOf.errors(new ValidationError.DecodingExpectedMapNodeType(path, node));
        }
        Class<?> klass = type.getRawType();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Method[] classMethods = klass.getMethods();
        DecoderService decoderService = decoderContext.getDecoderService();
        HashMap<String, Object> methodResults = new HashMap<String, Object>();
        for (Method method : classMethods) {
            String methodName = method.getName();
            Type returnType = method.getGenericReturnType();
            boolean foundValue = false;
            Config configAnnotation = method.getAnnotation(Config.class);
            String name = configAnnotation != null && configAnnotation.path() != null && !configAnnotation.path().isEmpty() ? configAnnotation.path() : ProxyDecoder.getConfigNameFromMethod(methodName, returnType);
            String nextPath = PathUtil.pathForKey(decoderContext.getDefaultLexer(), path, name);
            GResultOf<ConfigNode> configNode = decoderService.getNextNode(nextPath, name, node);
            errors.addAll(configNode.getErrorsNotLevel(ValidationLevel.MISSING_VALUE));
            if (configNode.hasResults()) {
                GResultOf fieldGResultOf = decoderService.decodeNode(nextPath, tags, configNode.results(), TypeCapture.of(returnType), decoderContext);
                errors.addAll(fieldGResultOf.getErrors());
                if (fieldGResultOf.hasResults()) {
                    methodResults.put(methodName, fieldGResultOf.results());
                    foundValue = true;
                }
            } else if (configAnnotation != null && configAnnotation.defaultVal() != null && !configAnnotation.defaultVal().isEmpty()) {
                GResultOf defaultGResultOf = decoderService.decodeNode(nextPath, tags, new LeafNode(configAnnotation.defaultVal()), TypeCapture.of(returnType), decoderContext);
                errors.addAll(defaultGResultOf.getErrors());
                if (defaultGResultOf.hasResults()) {
                    methodResults.put(methodName, defaultGResultOf.results());
                    foundValue = true;
                    errors.add(new ValidationError.OptionalMissingValueDecoding(nextPath, node, this.name(), klass.getSimpleName(), decoderContext));
                }
            } else {
                GResultOf decodedResults = decoderService.decodeNode(nextPath, tags, configNode.results(), TypeCapture.of(returnType), decoderContext);
                if (decodedResults.hasResults()) {
                    errors.addAll(decodedResults.getErrorsNotLevel(ValidationLevel.MISSING_OPTIONAL_VALUE));
                    errors.add(new ValidationError.OptionalMissingValueDecoding(nextPath, node, this.name(), klass.getSimpleName(), decoderContext));
                    foundValue = true;
                    methodResults.put(methodName, decodedResults.results());
                }
            }
            if (!foundValue && !method.isDefault()) {
                errors.add(new ValidationError.NoResultsFoundForNode(nextPath, type.getRawType(), "proxy decoding"));
                continue;
            }
            if (foundValue || !method.isDefault()) continue;
            errors.add(new ValidationError.OptionalMissingValueDecoding(nextPath, node, this.name(), klass.getSimpleName(), decoderContext));
        }
        switch (this.proxyDecoderMode) {
            case PASSTHROUGH: {
                proxyHandler = new ProxyPassThroughInvocationHandler(path, tags, decoderContext, this.config);
                break;
            }
            default: {
                proxyHandler = new ProxyCacheInvocationHandler(path, tags, decoderContext, this.config, methodResults);
                if (decoderContext.getGestalt() == null) break;
                decoderContext.getGestalt().registerListener((ProxyCacheInvocationHandler)proxyHandler);
            }
        }
        Object myProxy = Proxy.newProxyInstance(type.getRawType().getClassLoader(), new Class[]{type.getRawType()}, (InvocationHandler)proxyHandler);
        return GResultOf.resultOf(myProxy, errors);
    }

    static class ProxyCacheInvocationHandler
    extends ProxyPassThroughInvocationHandler
    implements InvocationHandler,
    CoreReloadListener {
        private static final System.Logger logger = System.getLogger(ProxyCacheInvocationHandler.class.getName());
        private final Map<String, Object> methodResults;

        private ProxyCacheInvocationHandler(String path, Tags tags, DecoderContext decoderContext, GestaltConfig config, Map<String, Object> methodResults) {
            super(path, tags, decoderContext, config);
            this.methodResults = methodResults;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            Object result = this.methodResults.get(methodName);
            if (result != null) {
                return result;
            }
            Optional<Object> resultOptional = this.retrieveConfig(proxy, method, args);
            Object gestaltResult = null;
            if (resultOptional.isPresent()) {
                gestaltResult = resultOptional.get();
            } else {
                Pair optionalInfo = ClassUtils.isOptionalAndDefault(returnType);
                if (optionalInfo.getFirst().booleanValue() && !this.config.isTreatMissingDiscretionaryValuesAsErrors()) {
                    gestaltResult = optionalInfo.getSecond();
                } else if (!this.config.isTreatMissingValuesAsErrors()) {
                    gestaltResult = returnType.isPrimitive() ? ClassUtils.getDefaultValue(returnType) : null;
                } else {
                    throw new GestaltException("Failed to get cached object from proxy config while calling method: " + methodName + " with type: " + returnType + " in path: " + this.path);
                }
            }
            this.methodResults.put(methodName, gestaltResult);
            return gestaltResult;
        }

        @Override
        public void reload() {
            logger.log(System.Logger.Level.DEBUG, "Reloading received on Proxy Cache Listener. Clearing Cache");
            this.methodResults.clear();
        }
    }

    static class ProxyPassThroughInvocationHandler
    implements InvocationHandler {
        protected final String path;
        protected final Tags tags;
        protected final DecoderContext decoderContext;
        protected final GestaltConfig config;

        private ProxyPassThroughInvocationHandler(String path, Tags tags, DecoderContext decoderContext, GestaltConfig config) {
            this.path = path;
            this.tags = tags;
            this.decoderContext = decoderContext;
            this.config = config;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            Optional<Object> result = this.retrieveConfig(proxy, method, args);
            Object gestaltResult = null;
            if (result.isPresent()) {
                gestaltResult = result.get();
            } else {
                Pair optionalInfo = ClassUtils.isOptionalAndDefault(returnType);
                if (optionalInfo.getFirst().booleanValue() && !this.config.isTreatMissingDiscretionaryValuesAsErrors()) {
                    gestaltResult = optionalInfo.getSecond();
                } else if (!this.config.isTreatMissingValuesAsErrors()) {
                    gestaltResult = returnType.isPrimitive() ? ClassUtils.getDefaultValue(returnType) : null;
                } else {
                    throw new GestaltException("Failed to get pass through object from proxy config while calling method: " + methodName + " with type: " + returnType + " in path: " + this.path);
                }
            }
            return gestaltResult;
        }

        protected Optional<Object> retrieveConfig(Object proxy, Method method, Object[] args) throws Throwable {
            GResultOf<?> defaultGResultOf;
            String methodName = method.getName();
            boolean isDefault = method.isDefault();
            Type genericType = method.getGenericReturnType();
            Class<?> returnType = method.getReturnType();
            Config configAnnotation = method.getAnnotation(Config.class);
            String name = configAnnotation != null && configAnnotation.path() != null && !configAnnotation.path().isEmpty() ? configAnnotation.path() : ProxyDecoder.getConfigNameFromMethod(methodName, returnType);
            String nextPath = PathUtil.pathForKey(this.decoderContext.getDefaultLexer(), this.path, name);
            Optional<Object> result = Optional.empty();
            if (this.decoderContext.getGestalt() != null) {
                result = this.decoderContext.getGestalt().getConfigOptional(nextPath, TypeCapture.of(genericType), this.tags);
            }
            if (result.isPresent()) {
                return result;
            }
            if (configAnnotation != null && configAnnotation.defaultVal() != null && !configAnnotation.defaultVal().isEmpty() && (defaultGResultOf = this.decoderContext.getDecoderService().decodeNode(nextPath, this.tags, new LeafNode(configAnnotation.defaultVal()), TypeCapture.of(returnType), this.decoderContext)).hasResults()) {
                return Optional.of(defaultGResultOf.results());
            }
            if (isDefault) {
                Object defaultResult = MethodHandles.lookup().findSpecial(method.getDeclaringClass(), methodName, MethodType.methodType(returnType, new Class[0]), method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(args);
                return Optional.of(defaultResult);
            }
            return Optional.empty();
        }
    }
}

