/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.github.gestalt.config.annotations.Config;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.DecoderService;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.entity.ValidationLevel;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.PathUtil;
import org.github.gestalt.config.utils.RecComponent;
import org.github.gestalt.config.utils.RecordUtils;

public final class RecordDecoder
implements Decoder<Object> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Record";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return RecordUtils.isRecord(type.getRawType());
    }

    @Override
    public GResultOf<Object> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        if (!(node instanceof MapNode)) {
            return GResultOf.errors(new ValidationError.DecodingExpectedLeafNodeType(path, node, this.name()));
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Class<?> klass = type.getRawType();
        DecoderService decoderService = decoderContext.getDecoderService();
        RecComponent[] recordComponents = RecordUtils.recordComponents(klass, Comparator.comparing(RecComponent::index));
        Object[] values = new Object[recordComponents.length];
        for (int i = 0; i < recordComponents.length; ++i) {
            RecComponent rc = recordComponents[i];
            boolean foundValue = false;
            String name = rc.name();
            Annotation[] annotations = rc.getDeclaredAnnotations();
            Config configAnnotation = rc.getAccessor().getAnnotation(Config.class);
            if (configAnnotation != null && configAnnotation.path() != null && !configAnnotation.path().isEmpty()) {
                name = configAnnotation.path();
            }
            Type fieldClass = rc.typeGeneric();
            String nextPath = PathUtil.pathForKey(decoderContext.getDefaultLexer(), path, name);
            GResultOf<ConfigNode> configNode = decoderService.getNextNode(nextPath, name, node);
            TypeCapture typeCapture = TypeCapture.of(fieldClass);
            errors.addAll(configNode.getErrorsNotLevel(ValidationLevel.MISSING_VALUE));
            if (configNode.hasResults()) {
                GResultOf fieldGResultOf = decoderService.decodeNode(nextPath, tags, configNode.results(), typeCapture, decoderContext);
                errors.addAll(fieldGResultOf.getErrors());
                if (fieldGResultOf.hasResults()) {
                    foundValue = true;
                    values[i] = fieldGResultOf.results();
                }
            } else if (configAnnotation != null && configAnnotation.defaultVal() != null && !configAnnotation.defaultVal().isEmpty()) {
                GResultOf defaultGResultOf = decoderService.decodeNode(nextPath, tags, new LeafNode(configAnnotation.defaultVal()), typeCapture, decoderContext);
                errors.addAll(defaultGResultOf.getErrors());
                if (defaultGResultOf.hasResults()) {
                    foundValue = true;
                    errors.add(new ValidationError.OptionalMissingValueDecoding(nextPath, node, this.name(), klass.getSimpleName(), decoderContext));
                    values[i] = defaultGResultOf.results();
                }
            } else {
                GResultOf decodedResults = decoderService.decodeNode(nextPath, tags, configNode.results(), typeCapture, decoderContext);
                if (decodedResults.hasResults()) {
                    errors.addAll(decodedResults.getErrorsNotLevel(ValidationLevel.MISSING_OPTIONAL_VALUE));
                    errors.add(new ValidationError.OptionalMissingValueDecoding(nextPath, node, this.name(), klass.getSimpleName(), decoderContext));
                    foundValue = true;
                    values[i] = decodedResults.results();
                }
            }
            if (foundValue) continue;
            boolean isNullable = RecordDecoder.isNullableAnnotation(annotations);
            values[i] = null;
            if (!isNullable) {
                errors.add(new ValidationError.NoResultsFoundForNode(nextPath, klass.getSimpleName(), "record decoding"));
                continue;
            }
            errors.add(new ValidationError.OptionalMissingValueDecoding(nextPath, node, this.name(), klass.getSimpleName(), decoderContext));
        }
        return GResultOf.resultOf(RecordUtils.invokeCanonicalConstructor(klass, recordComponents, values), errors);
    }

    private static boolean isNullableAnnotation(Annotation[] fieldAnnotations) {
        return Arrays.stream(fieldAnnotations).anyMatch(it -> it.annotationType().getName().toLowerCase(Locale.getDefault()).contains("nullable"));
    }
}

