/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.github.gestalt.config.decoder.CollectionDecoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.PathUtil;

public final class SetDecoder
extends CollectionDecoder<Set<?>> {
    private static final System.Logger logger = System.getLogger(SetDecoder.class.getName());
    Map<Class<?>, Supplier<Set>> supplierMap = new HashMap();
    Class<?> sequencedSet;

    public SetDecoder() {
        this.supplierMap.put(Set.class, HashSet::new);
        this.supplierMap.put(HashSet.class, HashSet::new);
        this.supplierMap.put(TreeSet.class, TreeSet::new);
        this.supplierMap.put(LinkedHashSet.class, LinkedHashSet::new);
        try {
            this.sequencedSet = Class.forName("java.util.SequencedSet");
            this.supplierMap.put(this.sequencedSet, LinkedHashSet::new);
        }
        catch (ClassNotFoundException e) {
            this.sequencedSet = null;
            logger.log(System.Logger.Level.TRACE, "Unable to find class java.util.SequencedSet, SequencedSetDecoder disabled");
        }
    }

    @Override
    public String name() {
        return "Set";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return Set.class.isAssignableFrom(type.getRawType()) && type.hasParameter();
    }

    @Override
    protected GResultOf<Set<?>> arrayDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> klass, DecoderContext decoderContext) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Supplier<Set> mapSupplier = this.supplierMap.get(klass.getRawType());
        if (mapSupplier == null) {
            logger.log(System.Logger.Level.TRACE, "Unable to find supplier for " + klass.getRawType() + ", defaulting to HashSet");
            mapSupplier = this.supplierMap.get(Set.class);
        }
        Set results = mapSupplier.get();
        for (int i = 0; i < node.size(); ++i) {
            Optional<ConfigNode> valueOptional = node.getIndex(i);
            if (valueOptional.isPresent()) {
                ConfigNode currentNode = valueOptional.get();
                String nextPath = PathUtil.pathForIndex(decoderContext.getDefaultLexer(), path, i);
                GResultOf<?> resultOf = decoderContext.getDecoderService().decodeNode(nextPath, tags, currentNode, klass.getFirstParameterType(), decoderContext);
                errors.addAll(resultOf.getErrors());
                if (!resultOf.hasResults()) continue;
                results.add(resultOf.results());
                continue;
            }
            errors.add(new ValidationError.ArrayMissingIndex(i, path));
        }
        return GResultOf.resultOf(results, errors);
    }
}

