/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Optional;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;

public final class StringConstructorDecoder
implements Decoder<Object> {
    @Override
    public Priority priority() {
        return Priority.LOW;
    }

    @Override
    public String name() {
        return "StringConstructor";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        Class<?> klass = type.getRawType();
        Constructor<?>[] stringConstructor = klass.getConstructors();
        if (!(node instanceof LeafNode)) {
            return false;
        }
        return Arrays.stream(stringConstructor).anyMatch(it -> it.getParameterCount() == 1 && it.getParameters()[0].getType().equals(String.class));
    }

    @Override
    public GResultOf<Object> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        LeafNode leafNode = (LeafNode)node;
        Optional<String> valueOptional = leafNode.getValue();
        if (valueOptional.isEmpty()) {
            return GResultOf.errors(new ValidationError.LeafNodesIsNullDecoding(path, type));
        }
        Class<?> klass = type.getRawType();
        try {
            Constructor<?> stringConstructor = klass.getConstructor(String.class);
            return GResultOf.result(stringConstructor.newInstance(valueOptional.get()));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return GResultOf.errors(new ValidationError.StringConstructorNotFound(path, type));
        }
    }
}

