/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.net.URI;
import java.net.URISyntaxException;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.LeafDecoder;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;

public final class URIDecoder
extends LeafDecoder<URI> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "URI";
    }

    @Override
    public boolean canDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> type) {
        return URI.class.isAssignableFrom(type.getRawType());
    }

    @Override
    protected GResultOf<URI> leafDecode(String path, ConfigNode node, DecoderContext decoderContext) {
        String value = node.getValue().orElse("");
        try {
            return GResultOf.result(new URI(value));
        }
        catch (URISyntaxException e) {
            return GResultOf.errors(new ValidationError.ErrorDecodingException(path, node, this.name(), e.getLocalizedMessage(), decoderContext));
        }
    }
}

