/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.entity;

import java.util.Optional;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.reload.CoreReloadListener;
import org.github.gestalt.config.tag.Tags;

public class ConfigContainer<T>
implements CoreReloadListener {
    private static final System.Logger logger = System.getLogger(ConfigContainer.class.getName());
    protected final String path;
    protected final Tags tags;
    protected final DecoderContext decoderContext;
    protected final TypeCapture<ConfigContainer<T>> klass;
    protected final TypeCapture<T> configContainerType;
    Optional<T> value;

    public ConfigContainer(String path, Tags tags, DecoderContext decoderContext, T value, TypeCapture<ConfigContainer<T>> klass) {
        this.path = path;
        this.tags = tags;
        this.decoderContext = decoderContext;
        this.klass = klass;
        this.value = Optional.ofNullable(value);
        this.configContainerType = klass.getFirstParameterType();
        decoderContext.getGestalt().registerListener(this);
    }

    public boolean isPresent() {
        return this.value.isPresent();
    }

    public T orElseThrow() throws GestaltException {
        return this.value.orElseThrow(() -> new GestaltException("No results for config path: " + this.path + ", tags: " + this.tags + ", and class: " + this.klass.getName()));
    }

    public Optional<T> getOptional() {
        return this.value;
    }

    @Override
    public void reload() {
        this.value = this.decoderContext.getGestalt().getConfigOptional(this.path, this.configContainerType, this.tags);
        if (this.value.isEmpty()) {
            logger.log(System.Logger.Level.WARNING, "On Reload, no results for config path: " + this.path + ", tags: " + this.tags + ", and class: " + this.klass.getName());
        }
    }
}

