/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.entity;

import java.util.Objects;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.tag.Tags;

public final class ConfigNodeContainer {
    private final ConfigNode configNode;
    private final ConfigSource source;
    private final Tags tags;

    public ConfigNodeContainer(ConfigNode configNode, ConfigSource source, Tags tags) {
        this.configNode = configNode;
        this.source = source;
        this.tags = tags;
    }

    public ConfigNode getConfigNode() {
        return this.configNode;
    }

    public ConfigSource getSource() {
        return this.source;
    }

    public Tags getTags() {
        return this.tags;
    }

    public boolean matchesTags(Tags match) {
        return this.tags.equals(match);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigNodeContainer)) {
            return false;
        }
        ConfigNodeContainer that = (ConfigNodeContainer)o;
        return Objects.equals(this.configNode, that.configNode) && Objects.equals(this.source, that.source) && Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hash(this.configNode, this.source, this.tags);
    }
}

