/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.entity;

import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.github.gestalt.config.decoder.ProxyDecoderMode;
import org.github.gestalt.config.entity.GestaltModuleConfig;
import org.github.gestalt.config.lexer.PathLexer;
import org.github.gestalt.config.lexer.SentenceLexer;

public class GestaltConfig {
    private final Map<Class, GestaltModuleConfig> modulesConfig = new HashMap<Class, GestaltModuleConfig>();
    private boolean treatWarningsAsErrors = false;
    private boolean treatMissingArrayIndexAsError = true;
    private boolean treatMissingValuesAsErrors = true;
    private boolean treatMissingDiscretionaryValuesAsErrors = false;
    private ProxyDecoderMode proxyDecoderMode = ProxyDecoderMode.CACHE;
    private System.Logger.Level logLevelForMissingValuesWhenDefaultOrOptional = System.Logger.Level.DEBUG;
    private DateTimeFormatter dateDecoderFormat = DateTimeFormatter.ISO_DATE_TIME;
    private DateTimeFormatter localDateTimeFormat = DateTimeFormatter.ISO_DATE_TIME;
    private DateTimeFormatter localDateFormat = DateTimeFormatter.ISO_DATE_TIME;
    private String substitutionOpeningToken = "${";
    private String substitutionClosingToken = "}";
    private String runTimeSubstitutionOpeningToken = "#{";
    private String runTimeSubstitutionClosingToken = "}";
    private String annotationOpeningToken = "@{";
    private String annotationClosingToken = "}";
    private Boolean annotationTrimWhiteSpace = true;
    private String annotationRegex = "^(?<annotation>\\w+)(:(?<parameter>.+?))?$";
    private int maxSubstitutionNestedDepth = 5;
    private String substitutionRegex = "^((?<transform>\\w+):(?!=))?(?<key>.+?)(:=(?<default>.*))?$";
    private String nodeIncludeKeyword = "$include";
    private Integer nodeNestedIncludeLimit = 5;
    private boolean observationsEnabled = false;
    private SentenceLexer sentenceLexer = new PathLexer();

    public boolean isTreatWarningsAsErrors() {
        return this.treatWarningsAsErrors;
    }

    public void setTreatWarningsAsErrors(boolean treatWarningsAsErrors) {
        this.treatWarningsAsErrors = treatWarningsAsErrors;
    }

    public boolean isTreatMissingArrayIndexAsError() {
        return this.treatMissingArrayIndexAsError;
    }

    public void setTreatMissingArrayIndexAsError(boolean treatMissingArrayIndexAsError) {
        this.treatMissingArrayIndexAsError = treatMissingArrayIndexAsError;
    }

    public boolean isTreatMissingValuesAsErrors() {
        return this.treatMissingValuesAsErrors;
    }

    public void setTreatMissingValuesAsErrors(boolean treatMissingValuesAsErrors) {
        this.treatMissingValuesAsErrors = treatMissingValuesAsErrors;
    }

    public boolean isTreatMissingDiscretionaryValuesAsErrors() {
        return this.treatMissingDiscretionaryValuesAsErrors;
    }

    public void setTreatMissingDiscretionaryValuesAsErrors(boolean treatMissingDiscretionaryValuesAsErrors) {
        this.treatMissingDiscretionaryValuesAsErrors = treatMissingDiscretionaryValuesAsErrors;
    }

    @Deprecated(since="0.25.0", forRemoval=true)
    public boolean isTreatNullValuesInClassAsErrors() {
        return false;
    }

    @Deprecated(since="0.25.0", forRemoval=true)
    public void setTreatNullValuesInClassAsErrors(boolean treatNullValuesInClassAsErrors) {
    }

    public ProxyDecoderMode getProxyDecoderMode() {
        return this.proxyDecoderMode;
    }

    public void setProxyDecoderMode(ProxyDecoderMode proxyDecoderMode) {
        this.proxyDecoderMode = proxyDecoderMode;
    }

    public System.Logger.Level getLogLevelForMissingValuesWhenDefaultOrOptional() {
        return this.logLevelForMissingValuesWhenDefaultOrOptional;
    }

    public void setLogLevelForMissingValuesWhenDefaultOrOptional(System.Logger.Level logLevelForMissingValuesWhenDefaultOrOptional) {
        this.logLevelForMissingValuesWhenDefaultOrOptional = logLevelForMissingValuesWhenDefaultOrOptional;
    }

    public DateTimeFormatter getDateDecoderFormat() {
        return this.dateDecoderFormat;
    }

    public void setDateDecoderFormat(DateTimeFormatter dateDecoderFormat) {
        this.dateDecoderFormat = dateDecoderFormat;
    }

    public DateTimeFormatter getLocalDateTimeFormat() {
        return this.localDateTimeFormat;
    }

    public void setLocalDateTimeFormat(DateTimeFormatter localDateTimeFormat) {
        this.localDateTimeFormat = localDateTimeFormat;
    }

    public DateTimeFormatter getLocalDateFormat() {
        return this.localDateFormat;
    }

    public void setLocalDateFormat(DateTimeFormatter localDateFormat) {
        this.localDateFormat = localDateFormat;
    }

    public String getSubstitutionOpeningToken() {
        return this.substitutionOpeningToken;
    }

    public void setSubstitutionOpeningToken(String substitutionOpeningToken) {
        this.substitutionOpeningToken = substitutionOpeningToken;
    }

    public String getSubstitutionClosingToken() {
        return this.substitutionClosingToken;
    }

    public void setSubstitutionClosingToken(String substitutionClosingToken) {
        this.substitutionClosingToken = substitutionClosingToken;
    }

    public String getRunTimeSubstitutionOpeningToken() {
        return this.runTimeSubstitutionOpeningToken;
    }

    public void setRunTimeSubstitutionOpeningToken(String runtTimeSubstitutionOpeningToken) {
        this.runTimeSubstitutionOpeningToken = runtTimeSubstitutionOpeningToken;
    }

    public String getRunTimeSubstitutionClosingToken() {
        return this.runTimeSubstitutionClosingToken;
    }

    public void setRunTimeSubstitutionClosingToken(String runTimeSubstitutionClosingToken) {
        this.runTimeSubstitutionClosingToken = runTimeSubstitutionClosingToken;
    }

    public String getAnnotationOpeningToken() {
        return this.annotationOpeningToken;
    }

    public void setAnnotationOpeningToken(String annotationOpeningToken) {
        this.annotationOpeningToken = annotationOpeningToken;
    }

    public String getAnnotationClosingToken() {
        return this.annotationClosingToken;
    }

    public void setAnnotationClosingToken(String annotationClosingToken) {
        this.annotationClosingToken = annotationClosingToken;
    }

    public Boolean getAnnotationTrimWhiteSpace() {
        return this.annotationTrimWhiteSpace;
    }

    public void setAnnotationTrimWhiteSpace(Boolean annotationTrimWhiteSpace) {
        this.annotationTrimWhiteSpace = annotationTrimWhiteSpace;
    }

    public String getAnnotationRegex() {
        return this.annotationRegex;
    }

    public void setAnnotationRegex(String annotationRegex) {
        this.annotationRegex = annotationRegex;
    }

    public int getMaxSubstitutionNestedDepth() {
        return this.maxSubstitutionNestedDepth;
    }

    public void setMaxSubstitutionNestedDepth(int maxSubstitutionNestedDepth) {
        this.maxSubstitutionNestedDepth = maxSubstitutionNestedDepth;
    }

    public String getSubstitutionRegex() {
        return this.substitutionRegex;
    }

    public void setSubstitutionRegex(String substitutionRegex) {
        this.substitutionRegex = substitutionRegex;
    }

    public String getNodeIncludeKeyword() {
        return this.nodeIncludeKeyword;
    }

    public void setNodeIncludeKeyword(String nodeImportKeyword) {
        this.nodeIncludeKeyword = nodeImportKeyword;
    }

    public Integer getNodeNestedIncludeLimit() {
        return this.nodeNestedIncludeLimit;
    }

    public void setNodeNestedIncludeLimit(Integer nodeNestedIncludeLimit) {
        this.nodeNestedIncludeLimit = nodeNestedIncludeLimit;
    }

    public boolean isObservationsEnabled() {
        return this.observationsEnabled;
    }

    public void setObservationsEnabled(boolean observationsEnabled) {
        this.observationsEnabled = observationsEnabled;
    }

    public SentenceLexer getSentenceLexer() {
        return this.sentenceLexer;
    }

    public void setSentenceLexer(SentenceLexer sentenceLexer) {
        this.sentenceLexer = sentenceLexer;
    }

    public void registerModuleConfig(GestaltModuleConfig module) {
        this.modulesConfig.put(module.getClass(), module);
    }

    public void registerModuleConfig(Map<Class, GestaltModuleConfig> module) {
        this.modulesConfig.putAll(module);
    }

    public <T extends GestaltModuleConfig> T getModuleConfig(Class<T> klass) {
        return (T)this.modulesConfig.get(klass);
    }
}

