/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.entity;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.entity.ValidationLevel;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.processor.config.transform.substitution.SubstitutionNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.secret.rules.SecretConcealer;
import org.github.gestalt.config.token.Token;

public abstract class ValidationError {
    private ValidationLevel level;

    protected ValidationError(ValidationLevel level) {
        this.level = level;
    }

    public abstract String description();

    public ValidationLevel level() {
        return this.level;
    }

    public void setLevel(ValidationLevel level) {
        this.level = level;
    }

    public boolean hasNoResults() {
        return this.level.equals((Object)ValidationLevel.MISSING_VALUE);
    }

    public boolean hasNoOptionalResults() {
        return this.level.equals((Object)ValidationLevel.MISSING_OPTIONAL_VALUE);
    }

    public static class UnknownAnnotation
    extends ValidationError {
        private final String annotation;
        private final String path;

        public UnknownAnnotation(String path, String annotation) {
            super(ValidationLevel.WARN);
            this.annotation = annotation;
            this.path = path;
        }

        @Override
        public String description() {
            return "Unknown annotation: " + this.annotation + " for path: " + this.path;
        }
    }

    public static class FailedToExtractAnnotation
    extends ValidationError {
        private final String element;
        private final String path;

        public FailedToExtractAnnotation(String path, String element) {
            super(ValidationLevel.WARN);
            this.element = element;
            this.path = path;
        }

        @Override
        public String description() {
            return "Unable to extract annotation using regex " + this.element + " for path: " + this.path;
        }
    }

    public static class NoAnnotationClosingToken
    extends ValidationError {
        private final String element;
        private final String path;

        public NoAnnotationClosingToken(String path, String element) {
            super(ValidationLevel.WARN);
            this.element = element;
            this.path = path;
        }

        @Override
        public String description() {
            return "Found annotation opening token but not a closing one: " + this.element + " for path: " + this.path;
        }
    }

    public static class ConfigNodeImportMaxNested
    extends ValidationError {
        private final String path;
        private final Integer numberNested;

        public ConfigNodeImportMaxNested(String path, Integer numberNested) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.numberNested = numberNested;
        }

        @Override
        public String description() {
            return "Reached the maximum nested import depth of: " + this.numberNested + ", on path: " + this.path + ", if this is intended increase the limit using GestaltBuilder.setNodeNestedIncludeLimit(10)";
        }
    }

    public static class ConfigNodeImportException
    extends ValidationError {
        private final String path;
        private final Exception ex;

        public ConfigNodeImportException(Exception ex) {
            super(ValidationLevel.ERROR);
            this.path = null;
            this.ex = ex;
        }

        public ConfigNodeImportException(String path, Exception ex) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.ex = ex;
        }

        @Override
        public String description() {
            if (this.path != null) {
                return "Exception while importing a Config Source on path : " + this.path + ", exception: " + this.ex.getMessage();
            }
            return "Exception while importing a Config Source exception: " + this.ex.getMessage();
        }
    }

    public static class ConfigNodeImportParameterHasWrongSize
    extends ValidationError {
        private final String path;
        private final String parameters;
        private final String parameter;

        public ConfigNodeImportParameterHasWrongSize(String path, String parameters, String parameter) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.parameters = parameters;
            this.parameter = parameter;
        }

        @Override
        public String description() {
            return "A Config node import parameter on path: " + this.path + " with parameters: " + this.parameters + ", has a invalid parameter " + this.parameter + " with the wrong size " + this.parameter.split("=").length;
        }
    }

    public static class ConfigNodeImportNodeEmpty
    extends ValidationError {
        private final String path;

        public ConfigNodeImportNodeEmpty(String path) {
            super(ValidationLevel.ERROR);
            this.path = path;
        }

        @Override
        public String description() {
            return "A Config node import is empty on path " + this.path;
        }
    }

    public static class ConfigNodeImportWrongNodeType
    extends ValidationError {
        private final String path;
        private final ConfigNode configNode;

        public ConfigNodeImportWrongNodeType(String path, ConfigNode configNode) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.configNode = configNode;
        }

        @Override
        public String description() {
            return "A Config node import is the wrong node type on path " + this.path + " expected a leaf received: " + this.configNode.getClass().getSimpleName();
        }
    }

    public static class ConfigSourceFactoryNotFound
    extends ValidationError {
        private final String source;

        public ConfigSourceFactoryNotFound(String source) {
            super(ValidationLevel.ERROR);
            this.source = source;
        }

        @Override
        public String description() {
            return "A Config Source Factory has not be found for source: " + this.source;
        }
    }

    public static class ConfigSourceFactoryNoSource
    extends ValidationError {
        private final Map<String, String> parameters;

        public ConfigSourceFactoryNoSource(Map<String, String> parameters) {
            super(ValidationLevel.ERROR);
            this.parameters = parameters;
        }

        @Override
        public String description() {
            return "Source name not provided while building Config Source Factory for parameters: " + this.parameters;
        }
    }

    public static class ConfigSourceFactoryException
    extends ValidationError {
        private final String factory;
        private final Exception ex;

        public ConfigSourceFactoryException(String factory, Exception ex) {
            super(ValidationLevel.ERROR);
            this.factory = factory;
            this.ex = ex;
        }

        @Override
        public String description() {
            return "Exception while building Config Source Factory: " + this.factory + ", exception: " + this.ex.getMessage();
        }
    }

    public static class ConfigSourceFactoryUnknownParameter
    extends ValidationError {
        private final String factory;
        private final String key;
        private final String value;

        public ConfigSourceFactoryUnknownParameter(String factory, String key, String value) {
            super(ValidationLevel.DEBUG);
            this.factory = factory;
            this.key = key;
            this.value = value;
        }

        @Override
        public String description() {
            return "Unknown Config Source Factory parameter for: " + this.factory + " Parameter key: " + this.key + ", value: " + this.value;
        }
    }

    public static class EncryptedNodeFailure
    extends ValidationError {
        private final String path;
        private final Exception ex;

        public EncryptedNodeFailure(String path, Exception ex) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.ex = ex;
        }

        @Override
        public String description() {
            return "Unable to encrypt node on path " + this.path + ", due to error " + this.ex.getMessage();
        }
    }

    public static class NodePostProcessingNodeLeafHasNoValue
    extends ValidationError {
        private final String path;
        private final String property;

        public NodePostProcessingNodeLeafHasNoValue(String path, String property) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.property = property;
        }

        @Override
        public String description() {
            return "leaf node has no value while running node transform path: " + this.path + " with: " + this.property;
        }
    }

    public static class NodePostProcessingNodeNotLeaf
    extends ValidationError {
        private final String path;
        private final String property;

        public NodePostProcessingNodeNotLeaf(String path, String property) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.property = property;
        }

        @Override
        public String description() {
            return "Non leaf node found while running node transform path: " + this.path + " with: " + this.property;
        }
    }

    public static class NodePostProcessingErrorsNavigatingToNode
    extends ValidationError {
        private final String path;
        private final String property;

        public NodePostProcessingErrorsNavigatingToNode(String path, String property) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.property = property;
        }

        @Override
        public String description() {
            return "Errors navigating to node while running node transform path: " + this.path + " with: " + this.property;
        }
    }

    public static class NodePostProcessingNoResults
    extends ValidationError {
        public NodePostProcessingNoResults() {
            super(ValidationLevel.MISSING_VALUE);
        }

        @Override
        public String description() {
            return "No results generated from post processor ";
        }

        @Override
        public boolean hasNoResults() {
            return true;
        }
    }

    public static class NodePostProcessingNoResultsForTokens
    extends ValidationError {
        private final String path;
        private final String property;

        public NodePostProcessingNoResultsForTokens(String path, String property) {
            super(ValidationLevel.MISSING_VALUE);
            this.path = path;
            this.property = property;
        }

        @Override
        public String description() {
            return "No results generating tokens while running node transform path: " + this.path + " with: " + this.property;
        }

        @Override
        public boolean hasNoResults() {
            return true;
        }
    }

    public static class NodePostProcessingBadTokens
    extends ValidationError {
        private final String path;
        private final String property;

        public NodePostProcessingBadTokens(String path, String property) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.property = property;
        }

        @Override
        public String description() {
            return "Errors generating tokens while running node transform path: " + this.path + " with: " + this.property;
        }
    }

    public static class NodePostProcessingConfigMissing
    extends ValidationError {
        private final String path;
        private final String property;

        public NodePostProcessingConfigMissing(String path, String property) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.property = property;
        }

        @Override
        public String description() {
            return "node Transform PostProcessorConfig is null, unable to transform path: " + this.path + " with: " + this.property;
        }
    }

    public static class ExceptionReadingFileDuringTransform
    extends ValidationError {
        private final String path;
        private final String file;
        private final String errorMsg;

        public ExceptionReadingFileDuringTransform(String path, String file, String errorMsg) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.file = file;
            this.errorMsg = errorMsg;
        }

        @Override
        public String description() {
            return "Exception transforming file while reading file: " + this.file + ", on path: " + this.path + " in with error: " + this.errorMsg;
        }
    }

    public static class InvalidBase64DecodeString
    extends ValidationError {
        private final String path;
        private final String value;
        private final String errorMsg;

        public InvalidBase64DecodeString(String path, String value, String errorMsg) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.value = value;
            this.errorMsg = errorMsg;
        }

        @Override
        public String description() {
            return "Invalid base 64 value: " + this.value + ", on path: " + this.path + " in with error: " + this.errorMsg;
        }
    }

    public static class Dist100DuplicateDefaults
    extends ValidationError {
        private final String path;
        private final String value;

        public Dist100DuplicateDefaults(String path, String value) {
            super(ValidationLevel.WARN);
            this.path = path;
            this.value = value;
        }

        @Override
        public String description() {
            return "Multiple default values found in Dist100 with : " + this.value + ", on path: " + this.path;
        }
    }

    public static class Dist100NoValueDetermined
    extends ValidationError {
        private final String path;
        private final String value;
        private final int random;

        public Dist100NoValueDetermined(String path, String value, int random) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.value = value;
            this.random = random;
        }

        @Override
        public String description() {
            return "Unable to determine a value for Dist100 with : " + this.value + ", on path: " + this.path + " and random value " + this.random + ", provide a default by having a value with no number ie 10:red,50:blue,green here green is the default";
        }
    }

    public static class InvalidStringSubstitutionPostProcess
    extends ValidationError {
        private final String path;
        private final String value;
        private final String transformer;

        public InvalidStringSubstitutionPostProcess(String path, String value, String transformer) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.value = value;
            this.transformer = transformer;
        }

        @Override
        public String description() {
            return "Invalid string: " + this.value + ", on path: " + this.path + " in transformer: " + this.transformer;
        }
    }

    public static class UnsupportedRandomPostProcess
    extends ValidationError {
        private final String path;
        private final String key;

        public UnsupportedRandomPostProcess(String path, String key) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.key = key;
        }

        @Override
        public String description() {
            return "Unsupported random post processor: " + this.key + ", on path: " + this.path + " during post process";
        }
    }

    public static class UnableToParseRandomExpression
    extends ValidationError {
        private final String path;
        private final String key;

        public UnableToParseRandomExpression(String path, String key) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.key = key;
        }

        @Override
        public String description() {
            return "Unable to parse random expression: " + this.key + ", on path: " + this.path + " during post process";
        }
    }

    public static class UnableToParseRandomParameter
    extends ValidationError {
        private final String path;
        private final String key;
        private final String type;
        private final String p1;
        private final String p2;

        public UnableToParseRandomParameter(String path, String key, String type, String p1, String p2) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.key = key;
            this.type = type;
            this.p1 = p1;
            this.p2 = p2;
        }

        @Override
        public String description() {
            return "Unable to parse random parameter: " + this.key + ", on path: " + this.path + " during post process, with parameters: " + this.p1 + ", " + this.p2 + " of type: " + this.type;
        }
    }

    public static class InvalidNumberOfParametersForRandomExpressionError
    extends ValidationError {
        private final String path;
        private final String key;
        private final String type;
        private final int expected;

        public InvalidNumberOfParametersForRandomExpressionError(String path, String key, String type, int expected) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.key = key;
            this.type = type;
            this.expected = expected;
        }

        @Override
        public String description() {
            return "Invalid number of parameters for type : " + this.type + ", from key: " + this.key + ", on path: " + this.path + " during post process. Must have " + this.expected + " parameters";
        }
    }

    public static class InvalidNumberOfParametersForRandomExpression
    extends ValidationError {
        private final String path;
        private final String key;
        private final String type;
        private final int expected;

        public InvalidNumberOfParametersForRandomExpression(String path, String key, String type, int expected) {
            super(ValidationLevel.WARN);
            this.path = path;
            this.key = key;
            this.type = type;
            this.expected = expected;
        }

        @Override
        public String description() {
            return "Invalid number of parameters for type : " + this.type + ", from key: " + this.key + ", on path: " + this.path + " during post process. Expected " + this.expected + " parameters";
        }
    }

    public static class NoEnvironmentVariableFoundPostProcess
    extends ValidationError {
        private final String path;
        private final String property;

        public NoEnvironmentVariableFoundPostProcess(String path, String property) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.property = property;
        }

        @Override
        public String description() {
            return "No Environment Variables found for: " + this.property + ", on path: " + this.path + " during post process";
        }
    }

    public static class NoCustomPropertyFoundPostProcess
    extends ValidationError {
        private final String path;
        private final String property;

        public NoCustomPropertyFoundPostProcess(String path, String property) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.property = property;
        }

        @Override
        public String description() {
            return "No custom Property found for: " + this.property + ", on path: " + this.path + " during post process";
        }
    }

    public static class NoSystemPropertyFoundPostProcess
    extends ValidationError {
        private final String path;
        private final String property;

        public NoSystemPropertyFoundPostProcess(String path, String property) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.property = property;
        }

        @Override
        public String description() {
            return "No System Property found for: " + this.property + ", on path: " + this.path + " during post process";
        }
    }

    public static class UnknownNodeTypePostProcess
    extends ValidationError {
        private final String nodeType;
        private final String path;

        public UnknownNodeTypePostProcess(String path, String nodeType) {
            super(ValidationLevel.ERROR);
            this.nodeType = nodeType;
            this.path = path;
        }

        @Override
        public String description() {
            return "Unknown node type: " + this.nodeType + " on Path: " + this.path + " while post processing";
        }
    }

    public static class ExceededMaximumNestedSubstitutionDepth
    extends ValidationError {
        private final String path;
        private final ConfigNode node;
        private final int depth;
        private final SecretConcealer secretConcealer;
        private final SentenceLexer lexer;

        public ExceededMaximumNestedSubstitutionDepth(String path, int depth, ConfigNode node, SecretConcealer secretConcealer, SentenceLexer lexer) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.node = node;
            this.depth = depth;
            this.secretConcealer = secretConcealer;
            this.lexer = lexer;
        }

        @Override
        public String description() {
            return "Exceeded maximum nested substitution depth of " + this.depth + " on path " + this.path + " for node: " + this.node.printer(this.path, this.secretConcealer, this.lexer);
        }
    }

    public static class NotAValidSubstitutionNode
    extends ValidationError {
        private final String path;
        private final SubstitutionNode node;

        public NotAValidSubstitutionNode(String path, SubstitutionNode node) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.node = node;
        }

        @Override
        public String description() {
            return "Unknown SubstitutionNode " + this.node + " on path " + this.path;
        }
    }

    public static class TransformDoesntMatchRegex
    extends ValidationError {
        private final String path;
        private final String value;

        public TransformDoesntMatchRegex(String path, String value) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.value = value;
        }

        @Override
        public String description() {
            return "Transform doesnt match the expected format with value " + this.value + " on path " + this.path;
        }
    }

    public static class NoKeyFoundForTransform
    extends ValidationError {
        private final String path;
        private final String transformName;
        private final String key;

        public NoKeyFoundForTransform(String path, String transformName, String key) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.transformName = transformName;
            this.key = key;
        }

        @Override
        public String description() {
            return "Unable to find matching key for transform " + this.transformName + " with key " + this.key + " on path " + this.path;
        }
    }

    public static class NoMatchingDefaultTransformFound
    extends ValidationError {
        private final String path;
        private final String key;

        public NoMatchingDefaultTransformFound(String path, String key) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.key = key;
        }

        @Override
        public String description() {
            return "Unable to find matching transform for " + this.path + " with the default transformers. For key: " + this.key + ", make sure you registered all expected transforms";
        }
    }

    public static class NoMatchingTransformFound
    extends ValidationError {
        private final String path;
        private final String transformName;

        public NoMatchingTransformFound(String path, String transformName) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.transformName = transformName;
        }

        @Override
        public String description() {
            return "Unable to find matching transform for " + this.path + " with transform: " + this.transformName + ". make sure you registered all expected transforms";
        }
    }

    public static class UnclosedSubstitutionTransform
    extends ValidationError {
        private final String path;
        private final String value;

        public UnclosedSubstitutionTransform(String path, String value) {
            super(ValidationLevel.DEBUG);
            this.path = path;
            this.value = value;
        }

        @Override
        public String description() {
            return "Reached the end of a string " + this.value + " with an unclosed substitution on path: " + this.path;
        }
    }

    public static class UnexpectedClosingTokenTransform
    extends ValidationError {
        private final String path;
        private final String value;
        private final String closingToken;
        private final int location;

        public UnexpectedClosingTokenTransform(String path, String value, String closingToken, int location) {
            super(ValidationLevel.DEBUG);
            this.path = path;
            this.value = value;
            this.closingToken = closingToken;
            this.location = location;
        }

        @Override
        public String description() {
            return "Unexpected closing token: " + this.closingToken + " found in string: " + this.value + ", at location: " + this.location + " on path: " + this.path + ", this error can have false positives";
        }
    }

    public static class NullValueDecodingObject
    extends ValidationError {
        private final String path;
        private final String field;
        private final String klassName;

        public NullValueDecodingObject(String path, String field, String klassName) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.field = field;
            this.klassName = klassName;
        }

        @Override
        public String description() {
            return "Decoding object : " + this.klassName + " on path: " + this.path + ", field " + this.field + " results in null value";
        }
    }

    public static class NoDefaultConstructor
    extends ValidationError {
        private final String path;
        private final String klassName;

        public NoDefaultConstructor(String path, String klassName) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.klassName = klassName;
        }

        @Override
        public String description() {
            return "No default Constructor for : " + this.klassName + " on Path: " + this.path;
        }
    }

    public static class ConstructorNotPublic
    extends ValidationError {
        private final String path;
        private final String klassName;

        public ConstructorNotPublic(String path, String klassName) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.klassName = klassName;
        }

        @Override
        public String description() {
            return "Constructor for: " + this.klassName + " is not public on Path: " + this.path;
        }
    }

    public static class StringConstructorNotFound
    extends ValidationError {
        private final String path;
        private final TypeCapture<?> type;

        public StringConstructorNotFound(String path, TypeCapture<?> type) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.type = type;
        }

        @Override
        public String description() {
            return "String Constructor for: " + this.type.getRawType().getSimpleName() + " is not found on Path: " + this.path;
        }
    }

    public static class LeafNodesHaveNoValues
    extends ValidationError {
        private final String path;

        public LeafNodesHaveNoValues(String path) {
            super(ValidationLevel.WARN);
            this.path = path;
        }

        @Override
        public String description() {
            return "Leaf nodes are empty for path: " + this.path;
        }
    }

    public static class LeafNodesIsNullDecoding
    extends ValidationError {
        private final String path;
        private final TypeCapture<?> type;

        public LeafNodesIsNullDecoding(String path, TypeCapture<?> type) {
            super(ValidationLevel.MISSING_VALUE);
            this.path = path;
            this.type = type;
        }

        @Override
        public String description() {
            return "Leaf nodes is null on path: " + this.path + " decoding type " + this.type.getRawType().getSimpleName();
        }
    }

    public static class LeafNodesIsNull
    extends ValidationError {
        private final String path;

        public LeafNodesIsNull(String path) {
            super(ValidationLevel.WARN);
            this.path = path;
        }

        @Override
        public String description() {
            return "Leaf nodes is null: " + this.path;
        }
    }

    public static class ExceptionDecodingEnum
    extends ValidationError {
        private final String path;
        private final String enumValue;
        private final Class<?> enumClass;
        private final Exception exception;

        public ExceptionDecodingEnum(String path, String enumValue, Class<?> enumClass, Exception exception) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.enumValue = enumValue;
            this.enumClass = enumClass;
            this.exception = exception;
        }

        @Override
        public String description() {
            return "Exception on Path: " + this.path + ", decoding enum: " + this.enumClass.getName() + " could not be created with value " + this.enumValue + " exception was: " + this.exception.getMessage();
        }
    }

    public static class EnumValueNotFound
    extends ValidationError {
        private final String path;
        private final String enumValue;
        private final Class<?> enumClass;

        public EnumValueNotFound(String path, String enumValue, Class<?> enumClass) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.enumValue = enumValue;
            this.enumClass = enumClass;
        }

        @Override
        public String description() {
            return "ENUM " + this.enumClass.getName() + " could not be created with value " + this.enumValue + " for Path: " + this.path;
        }
    }

    public static class UnknownNodeType
    extends ValidationError {
        private final String nodeType;
        private final String path;

        public UnknownNodeType(String path, String nodeType) {
            super(ValidationLevel.ERROR);
            this.nodeType = nodeType;
            this.path = path;
        }

        @Override
        public String description() {
            return "Unknown node type: " + this.nodeType + " on Path: " + this.path;
        }
    }

    public static class UnableToMergeDifferentNodes
    extends ValidationError {
        private final Class<?> klass1;
        private final Class<?> klass2;

        public UnableToMergeDifferentNodes(Class<?> klass1, Class<?> klass2) {
            super(ValidationLevel.ERROR);
            this.klass1 = klass1;
            this.klass2 = klass2;
        }

        @Override
        public String description() {
            return "Unable to merge different nodes, of type: " + this.klass1.getSimpleName() + " and type: " + this.klass2.getSimpleName();
        }
    }

    public static class UnknownNodeTypeDuringLoad
    extends ValidationError {
        private final String nodeType;
        private final String path;

        public UnknownNodeTypeDuringLoad(String path, String nodeType) {
            super(ValidationLevel.ERROR);
            this.nodeType = nodeType;
            this.path = path;
        }

        @Override
        public String description() {
            return "Unknown node type: " + this.nodeType + " on Path: " + this.path;
        }
    }

    public static class UnsupportedTokenType
    extends ValidationError {
        private final String path;
        private final Token token;

        public UnsupportedTokenType(String path, Token token) {
            super(ValidationLevel.WARN);
            this.path = path;
            this.token = token;
        }

        @Override
        public String description() {
            return "unsupported token: " + this.token.getClass().getSimpleName() + " for path: " + this.path;
        }
    }

    public static class NullTokenForPath
    extends ValidationError {
        private final String path;

        public NullTokenForPath(String path) {
            super(ValidationLevel.WARN);
            this.path = path;
        }

        @Override
        public String description() {
            return "Null or Empty Token on path: " + this.path;
        }
    }

    public static class NullNodeForPath
    extends ValidationError {
        private final String path;

        public NullNodeForPath(String path) {
            super(ValidationLevel.WARN);
            this.path = path;
        }

        @Override
        public String description() {
            return "Null Nodes on path: " + this.path;
        }
    }

    public static class MismatchedObjectNodeForPath
    extends ValidationError {
        private final String path;
        private final Class<?> expectedKlass;
        private final Class<?> actualKlass;

        public MismatchedObjectNodeForPath(String path, Class<?> expectedKlass, Class<?> actualKlass) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.expectedKlass = expectedKlass;
            this.actualKlass = actualKlass;
        }

        @Override
        public String description() {
            return "Mismatched Nodes on path: " + this.path + ", expected: " + this.expectedKlass.getSimpleName() + " received: " + this.actualKlass.getSimpleName();
        }
    }

    public static class EmptyNodeValueProvided
    extends ValidationError {
        private final String path;
        private final String key;

        public EmptyNodeValueProvided(String path, String key) {
            super(ValidationLevel.WARN);
            this.path = path;
            this.key = key;
        }

        @Override
        public String description() {
            return "Empty node value provided for path: " + this.path + "." + this.key;
        }
    }

    public static class EmptyNodeNameProvided
    extends ValidationError {
        private final String path;

        public EmptyNodeNameProvided(String path) {
            super(ValidationLevel.WARN);
            this.path = path;
        }

        @Override
        public String description() {
            return "Empty node name provided for path: " + this.path;
        }
    }

    public static class NoResultsFoundForNode
    extends ValidationError {
        private final String path;
        private final String area;
        private String klass;

        public NoResultsFoundForNode(String path, String area) {
            super(ValidationLevel.MISSING_VALUE);
            this.path = path;
            this.area = area;
        }

        public NoResultsFoundForNode(String path, String klass, String area) {
            super(ValidationLevel.MISSING_VALUE);
            this.path = path;
            this.klass = klass;
            this.area = area;
        }

        public NoResultsFoundForNode(String path, Class<?> klass, String area) {
            super(ValidationLevel.MISSING_VALUE);
            this.path = path;
            this.klass = klass.getSimpleName();
            this.area = area;
        }

        @Override
        public String description() {
            if (this.klass != null) {
                return "Unable to find node matching path: " + this.path + ", for class: " + this.klass + ", during " + this.area;
            }
            return "Unable to find node matching path: " + this.path + ", during " + this.area;
        }

        @Override
        public boolean hasNoResults() {
            return true;
        }
    }

    public static class NoDecodersFound
    extends ValidationError {
        private final String klass;
        private final ConfigNode configNode;

        public NoDecodersFound(String klass, ConfigNode configNode) {
            super(ValidationLevel.ERROR);
            this.klass = klass;
            this.configNode = configNode;
        }

        @Override
        public String description() {
            return "No decoders found for class: " + this.klass + " and node type: " + this.configNode.getNodeType().getType();
        }
    }

    public static class MapEntryInvalid
    extends ValidationError {
        private final String path;
        private final String content;
        private final ConfigNode node;
        private final DecoderContext context;

        public MapEntryInvalid(String path, String content, ConfigNode node, DecoderContext context) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.content = content;
            this.node = node;
            this.context = context;
        }

        @Override
        public String description() {
            return "Map entry is not in the format '<KEY>=<VALUE> for entry" + this.content + ", on path " + this.path + ", for node: " + this.node.printer(this.path, this.context.getSecretConcealer(), this.context.getDefaultLexer());
        }
    }

    public static class DecodersMapValueNull
    extends ValidationError {
        private final String path;

        public DecodersMapValueNull(String path) {
            super(ValidationLevel.ERROR);
            this.path = path;
        }

        @Override
        public String description() {
            return "Map key was null on path: " + this.path;
        }
    }

    public static class DecodersMapKeyNull
    extends ValidationError {
        private final String path;

        public DecodersMapKeyNull(String path) {
            super(ValidationLevel.ERROR);
            this.path = path;
        }

        @Override
        public String description() {
            return "Map key was null on path: " + this.path;
        }
    }

    public static class ErrorDecodingException
    extends ValidationError {
        private final String path;
        private final ConfigNode node;
        private final String decoder;
        private final String reason;
        private final DecoderContext context;

        public ErrorDecodingException(String path, ConfigNode node, String decoder, String reason, DecoderContext context) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.node = node;
            this.decoder = decoder;
            this.reason = reason;
            this.context = context;
        }

        @Override
        public String description() {
            return "Unable to decode a " + this.decoder + " on path: " + this.path + ", from node: " + this.node.printer(this.path, this.context.getSecretConcealer(), this.context.getDefaultLexer()) + ", with reason: " + this.reason;
        }
    }

    public static class DecodingEmptyByte
    extends ValidationError {
        private final String path;
        private final ConfigNode node;
        private final DecoderContext context;

        public DecodingEmptyByte(String path, ConfigNode node, DecoderContext context) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.node = node;
            this.context = context;
        }

        @Override
        public String description() {
            return "Expected a Byte on path: " + this.path + ", decoding node: " + this.node.printer(this.path, this.context.getSecretConcealer(), this.context.getDefaultLexer()) + " received an empty node";
        }
    }

    public static class DecodingByteTooLong
    extends ValidationError {
        private final String path;
        private final ConfigNode node;
        private final DecoderContext context;

        public DecodingByteTooLong(String path, ConfigNode node, DecoderContext context) {
            super(ValidationLevel.WARN);
            this.path = path;
            this.node = node;
            this.context = context;
        }

        @Override
        public String description() {
            return "Expected a Byte on path: " + this.path + ", decoding node: " + this.node.printer(this.path, this.context.getSecretConcealer(), this.context.getDefaultLexer()) + " received the wrong size";
        }
    }

    public static class DecodingCharWrongSize
    extends ValidationError {
        private final String path;
        private final ConfigNode node;
        private final DecoderContext context;

        public DecodingCharWrongSize(String path, ConfigNode node, DecoderContext context) {
            super(ValidationLevel.WARN);
            this.path = path;
            this.node = node;
            this.context = context;
        }

        @Override
        public String description() {
            return "Expected a char on path: " + this.path + ", decoding node: " + this.node.printer(this.path, this.context.getSecretConcealer(), this.context.getDefaultLexer()) + " received the wrong size";
        }
    }

    public static class DecodingNumberFormatException
    extends ValidationError {
        private final String path;
        private final ConfigNode node;
        private final String nodeType;
        private final DecoderContext context;

        public DecodingNumberFormatException(String path, ConfigNode node, String nodeType, DecoderContext context) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.node = node;
            this.nodeType = nodeType;
            this.context = context;
        }

        @Override
        public String description() {
            return "Unable to decode a number on path: " + this.path + ", from node: " + this.node.printer(this.path, this.context.getSecretConcealer(), this.context.getDefaultLexer()) + " attempting to decode " + this.nodeType;
        }
    }

    public static class DecodingNumberParsing
    extends ValidationError {
        private final String path;
        private final ConfigNode node;
        private final String decoderName;

        public DecodingNumberParsing(String path, ConfigNode node, String decoderName) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.node = node;
            this.decoderName = decoderName;
        }

        @Override
        public String description() {
            return "Unable to parse a number on Path: " + this.path + ", from node: " + this.node + " attempting to decode " + this.decoderName;
        }
    }

    public static class DecodingExpectedMapNodeType
    extends ValidationError {
        private final String path;
        private final List<TypeCapture<?>> types;
        private final ConfigNode node;

        public DecodingExpectedMapNodeType(String path, List<TypeCapture<?>> types, ConfigNode node) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.types = types;
            this.node = node;
        }

        public DecodingExpectedMapNodeType(String path, ConfigNode node) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.types = null;
            this.node = node;
        }

        @Override
        public String description() {
            if (this.types == null) {
                return "Expected a map node on path: " + this.path + ", received node type : " + (Serializable)(this.node == null ? "null" : this.node.getNodeType());
            }
            return "Expected a map on path: " + this.path + ", received node type : " + (this.node == null ? "null" : this.node.getNodeType().getType()) + ", received invalid types: " + this.types;
        }
    }

    public static class DecodingExpectedArrayNodeType
    extends ValidationError {
        private final String path;
        private final ConfigNode node;
        private final String decoderName;

        public DecodingExpectedArrayNodeType(String path, ConfigNode node, String decoderName) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.node = node;
            this.decoderName = decoderName;
        }

        @Override
        public String description() {
            return "Expected a Array on path: " + this.path + ", received node type: " + (Serializable)(this.node == null ? "null" : this.node.getNodeType()) + ", attempting to decode " + this.decoderName;
        }
    }

    public static class DecodingExpectedLeafNodeType
    extends ValidationError {
        private final String path;
        private final ConfigNode node;
        private final String decoderName;

        public DecodingExpectedLeafNodeType(String path, ConfigNode node, String decoderName) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.node = node;
            this.decoderName = decoderName;
        }

        @Override
        public String description() {
            return "Expected a leaf on path: " + this.path + ", received node type: " + (this.node == null ? "null" : this.node.getNodeType().getType()) + ", attempting to decode " + this.decoderName;
        }
    }

    public static class DecodingLeafMissingValue
    extends ValidationError {
        private final String path;
        private final String decoderName;

        public DecodingLeafMissingValue(String path, String decoderName) {
            super(ValidationLevel.MISSING_VALUE);
            this.path = path;
            this.decoderName = decoderName;
        }

        @Override
        public String description() {
            return "Leaf on path: " + this.path + ", has no value attempting to decode " + this.decoderName;
        }

        @Override
        public boolean hasNoResults() {
            return true;
        }
    }

    public static class NoResultsMappingPath
    extends ValidationError {
        private final String path;
        private final String nextPath;
        private final String area;

        public NoResultsMappingPath(String path, String nextPath, String area) {
            super(ValidationLevel.MISSING_VALUE);
            this.path = path;
            this.nextPath = nextPath;
            this.area = area;
        }

        @Override
        public String description() {
            return "No results from mapping path: " + this.path + ", with next path: " + this.nextPath + ", during " + this.area;
        }

        @Override
        public boolean hasNoResults() {
            return true;
        }
    }

    public static class MappingPathEmpty
    extends ValidationError {
        private final String path;
        private final String mapper;

        public MappingPathEmpty(String path, String mapper) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.mapper = mapper;
        }

        @Override
        public String description() {
            return "Mapper: " + this.mapper + " token was null or empty on path: " + this.path;
        }
    }

    public static class OptionalMissingValueDecoding
    extends ValidationError {
        private final String path;
        private final ConfigNode node;
        private final String decoder;
        private final String className;
        private final DecoderContext context;

        public OptionalMissingValueDecoding(String path, String decoder, DecoderContext context) {
            this(path, null, decoder, null, context);
        }

        public OptionalMissingValueDecoding(String path, ConfigNode node, String decoder, DecoderContext context) {
            this(path, node, decoder, null, context);
        }

        public OptionalMissingValueDecoding(String path, ConfigNode node, String decoder, String className, DecoderContext context) {
            super(ValidationLevel.MISSING_OPTIONAL_VALUE);
            this.path = path;
            this.node = node;
            this.decoder = decoder;
            this.className = className;
            this.context = context;
        }

        @Override
        public String description() {
            StringBuilder description = new StringBuilder(62);
            description.append("Missing Optional Value while decoding ").append(this.decoder).append(" on path: ").append(this.path);
            if (this.node != null) {
                description.append(", with node: ").append(this.node.printer(this.path, this.context.getSecretConcealer(), this.context.getDefaultLexer()));
            }
            if (this.className != null) {
                description.append(", with class: ").append(this.className);
            }
            return description.toString();
        }
    }

    public static class NoResultsFoundForPath
    extends ValidationError {
        private final String path;

        public NoResultsFoundForPath(String path) {
            super(ValidationLevel.MISSING_VALUE);
            this.path = path;
        }

        @Override
        public String description() {
            return "Unable to find node matching path: " + this.path;
        }

        @Override
        public boolean hasNoResults() {
            return true;
        }
    }

    public static class ArrayLeafAndNotLeaf
    extends ValidationError {
        private final String path;
        private final List<Integer> sizes;

        public ArrayLeafAndNotLeaf(List<Integer> sizes, String path) {
            super(ValidationLevel.ERROR);
            this.sizes = sizes;
            this.path = path;
        }

        @Override
        public String description() {
            return "Array is both a leaf and non leaf with sizes: " + this.sizes + " for path: " + this.path;
        }
    }

    public static class ArrayDuplicateIndex
    extends ValidationError {
        private final long index;
        private final String path;

        public ArrayDuplicateIndex(long index, String path) {
            super(ValidationLevel.ERROR);
            this.index = index;
            this.path = path;
        }

        @Override
        public String description() {
            return "Duplicate array index: " + this.index + " for path: " + this.path;
        }
    }

    public static class ArrayInvalidIndex
    extends ValidationError {
        private final long index;
        private final String path;

        public ArrayInvalidIndex(long index, String path) {
            super(ValidationLevel.ERROR);
            this.index = index;
            this.path = path;
        }

        @Override
        public String description() {
            return "Invalid array index: " + this.index + " for path: " + this.path;
        }
    }

    public static class ArrayMissingIndex
    extends ValidationError {
        private final long index;
        private final String path;

        public ArrayMissingIndex(long index) {
            super(ValidationLevel.MISSING_VALUE);
            this.index = index;
            this.path = null;
        }

        public ArrayMissingIndex(long index, String path) {
            super(ValidationLevel.MISSING_VALUE);
            this.index = index;
            this.path = path;
        }

        @Override
        public String description() {
            if (this.path != null) {
                return "Missing array index: " + this.index + " for path: " + this.path;
            }
            return "Missing array index: " + this.index;
        }
    }

    public static class MultipleTokenTypes
    extends ValidationError {
        private final String path;
        private final List<Token> tokens;

        public MultipleTokenTypes(String path, List<Token> tokens) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.tokens = tokens;
        }

        @Override
        public String description() {
            return "Found multiple token types " + this.tokens + " for path " + this.path;
        }
    }

    public static class NoTokensInPath
    extends ValidationError {
        private final String path;

        public NoTokensInPath(String path) {
            super(ValidationLevel.ERROR);
            this.path = path;
        }

        @Override
        public String description() {
            return "Unable to find a token for path: " + this.path + " while building a config node";
        }
    }

    public static class PathLengthErrors
    extends ValidationError {
        private final String paths;

        public PathLengthErrors(String paths) {
            super(ValidationLevel.ERROR);
            this.paths = paths;
        }

        @Override
        public String description() {
            return "Parsing path length errors for path: " + this.paths + ", there could be several causes such as: duplicate paths, or a node is both a leaf and an object";
        }
    }

    public static class UnknownTokenWithPath
    extends ValidationError {
        private final Token token;
        private final String path;

        public UnknownTokenWithPath(Token token, String path) {
            super(ValidationLevel.ERROR);
            this.token = token;
            this.path = path;
        }

        @Override
        public String description() {
            return "Unknown token type " + this.token + " for path: " + this.path;
        }
    }

    public static class EmptyToken
    extends ValidationError {
        public EmptyToken() {
            super(ValidationLevel.ERROR);
        }

        @Override
        public String description() {
            return "Empty or null token provided while building the config node";
        }
    }

    public static class InvalidArrayNegativeIndexToken
    extends ValidationError {
        private final String path;
        private final String element;
        private final int index;

        public InvalidArrayNegativeIndexToken(String element, int index, String path) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.element = element;
            this.index = index;
        }

        @Override
        public String description() {
            return "Array index can not be negative: " + this.index + " provided provided for element: " + this.element + " for path: " + this.path;
        }
    }

    public static class InvalidArrayIndexToken
    extends ValidationError {
        private final String path;
        private final String element;

        public InvalidArrayIndexToken(String element, String path) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.element = element;
        }

        @Override
        public String description() {
            return "Array index not provided provided for element " + this.element + " for path: " + this.path;
        }
    }

    public static class InvalidArrayToken
    extends ValidationError {
        private final String path;
        private final String element;
        private final String arrayIndex;

        public InvalidArrayToken(String element, String arrayIndex, String path) {
            super(ValidationLevel.ERROR);
            this.path = path;
            this.element = element;
            this.arrayIndex = arrayIndex;
        }

        @Override
        public String description() {
            return "Array index provided: " + this.arrayIndex + " for element " + this.element + " but unable to parse as int for path: " + this.path;
        }
    }

    public static class UnableToParseName
    extends ValidationError {
        private final String path;

        public UnableToParseName(String path) {
            super(ValidationLevel.ERROR);
            this.path = path;
        }

        @Override
        public String description() {
            return "unable to parse the name for path: " + this.path;
        }
    }

    public static class FailedToTokenizeElement
    extends ValidationError {
        private final String element;
        private final String path;

        public FailedToTokenizeElement(String element, String path) {
            super(ValidationLevel.ERROR);
            this.element = element;
            this.path = path;
        }

        @Override
        public String description() {
            return "Unable to tokenize element " + this.element + " for path: " + this.path;
        }
    }

    public static class EmptyElement
    extends ValidationError {
        private final String path;

        public EmptyElement(String path) {
            super(ValidationLevel.WARN);
            this.path = path;
        }

        @Override
        public String description() {
            return "empty element for path: " + this.path;
        }
    }

    public static class EmptyPath
    extends ValidationError {
        public EmptyPath() {
            super(ValidationLevel.WARN);
        }

        @Override
        public String description() {
            return "empty path provided";
        }
    }
}

