/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.lexer;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.lexer.LowerCaseSentenceNormalizer;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.lexer.SentenceNormalizer;
import org.github.gestalt.config.token.ArrayToken;
import org.github.gestalt.config.token.ObjectToken;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.StringUtils;

public final class PathLexer
extends SentenceLexer {
    public static final String DEFAULT_EVALUATOR = "^((?<name>[\\w .,+=\\-;:\"'`~!@#$%^&*()\\<>]+)(?<array>\\[(?<index>\\d*)])?)$";
    public static final String DELIMITER_DEFAULT = ".";
    private final Pattern pathPattern;
    private final String normalizedDelimiter;
    private final String normalizedArrayOpenTag;
    private final String normalizedArrayCloseTag;
    private final String normalizedMapTag;
    private final String delimiter;
    private final Pattern delimiterRegex;
    private final SentenceNormalizer sentenceNormalizer;

    public PathLexer() {
        this(DELIMITER_DEFAULT, DELIMITER_DEFAULT, DEFAULT_EVALUATOR, new LowerCaseSentenceNormalizer(), "[", "]", "=");
    }

    public PathLexer(String delimiter) {
        this(delimiter, delimiter, DEFAULT_EVALUATOR, new LowerCaseSentenceNormalizer(), "[", "]", "=");
    }

    public PathLexer(String delimiter, String pathPatternRegex) {
        this(delimiter, delimiter, pathPatternRegex, new LowerCaseSentenceNormalizer(), "[", "]", "=");
    }

    public PathLexer(String delimiter, String pathPatternRegex, SentenceNormalizer sentenceNormalizer) {
        this(delimiter, delimiter, pathPatternRegex, sentenceNormalizer, "[", "]", "=");
    }

    public PathLexer(String normalizedDelimiter, String delimiter, String pathPatternRegex, SentenceNormalizer sentenceNormalizer) {
        this(normalizedDelimiter, delimiter, pathPatternRegex, sentenceNormalizer, "[", "]", "=");
    }

    public PathLexer(String normalizedDelimiter, String delimiter, String pathPatternRegex, SentenceNormalizer sentenceNormalizer, String normalizedArrayOpenTag, String normalizedArrayCloseTag, String normalizedMapTag) {
        this.pathPattern = Pattern.compile(pathPatternRegex, 2);
        this.normalizedDelimiter = normalizedDelimiter;
        this.delimiter = delimiter;
        this.delimiterRegex = delimiter.length() == 1 ? Pattern.compile(Pattern.quote(delimiter)) : Pattern.compile(delimiter);
        this.sentenceNormalizer = sentenceNormalizer;
        this.normalizedArrayOpenTag = normalizedArrayOpenTag;
        this.normalizedArrayCloseTag = normalizedArrayCloseTag;
        this.normalizedMapTag = normalizedMapTag;
    }

    @Override
    public String getNormalizedDeliminator() {
        return this.normalizedDelimiter;
    }

    @Override
    public String getNormalizedArrayOpenTag() {
        return this.normalizedArrayOpenTag;
    }

    @Override
    public String getNormalizedArrayCloseTag() {
        return this.normalizedArrayCloseTag;
    }

    @Override
    public String getNormalizedMapTag() {
        return this.normalizedMapTag;
    }

    @Override
    public String getDeliminator() {
        return this.delimiter;
    }

    @Override
    public List<String> tokenizer(String sentence) {
        return sentence != null && !sentence.isEmpty() ? List.of(this.delimiterRegex.split(sentence)) : Collections.emptyList();
    }

    @Override
    protected GResultOf<List<Token>> evaluator(String word, String sentence) {
        GResultOf<List<Token>> results;
        if (sentence == null || sentence.isEmpty()) {
            return GResultOf.errors(new ValidationError.EmptyPath());
        }
        if (word == null || word.isEmpty()) {
            return GResultOf.errors(new ValidationError.EmptyElement(sentence));
        }
        Matcher matcher = this.pathPattern.matcher(word);
        if (!matcher.find()) {
            return GResultOf.errors(new ValidationError.FailedToTokenizeElement(word, sentence));
        }
        String name = matcher.group("name");
        if (name == null || name.isEmpty()) {
            return GResultOf.errors(new ValidationError.UnableToParseName(sentence));
        }
        String array = matcher.group("array");
        String arrayIndex = matcher.group("index");
        if (array != null && arrayIndex != null && !arrayIndex.isEmpty()) {
            int index;
            results = StringUtils.isInteger(arrayIndex) ? ((index = Integer.parseInt(arrayIndex)) >= 0 ? GResultOf.result(List.of(new ObjectToken(name), new ArrayToken(index))) : GResultOf.errors(new ValidationError.InvalidArrayNegativeIndexToken(word, index, sentence))) : GResultOf.errors(new ValidationError.InvalidArrayToken(word, arrayIndex, sentence));
        } else if (array != null) {
            results = GResultOf.errors(new ValidationError.InvalidArrayIndexToken(word, sentence));
        } else {
            ObjectToken object = new ObjectToken(name);
            List<ObjectToken> list = Collections.singletonList(object);
            results = GResultOf.result(list);
        }
        return results;
    }

    @Override
    public String normalizeSentence(String sentence) {
        return this.sentenceNormalizer.normalizeSentence(sentence);
    }
}

