/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.lexer;

import org.github.gestalt.config.lexer.LowerCaseSentenceNormalizer;
import org.github.gestalt.config.lexer.PathLexer;
import org.github.gestalt.config.lexer.SentenceNormalizer;

public final class PathLexerBuilder {
    private String normalizedDelimiter = ".";
    private String normalizedArrayOpenTag = "[";
    private String normalizedArrayCloseTag = "]";
    private String normalizedMapTag = "=";
    private String delimiter = ".";
    private SentenceNormalizer sentenceNormalizer = new LowerCaseSentenceNormalizer();
    private String pathPatternRegex = "^((?<name>[\\w .,+=\\-;:\"'`~!@#$%^&*()\\<>]+)(?<array>\\[(?<index>\\d*)])?)$";

    private PathLexerBuilder() {
    }

    public static PathLexerBuilder builder() {
        return new PathLexerBuilder();
    }

    public PathLexerBuilder setNormalizedDelimiter(String normalizedDelimiter) {
        this.normalizedDelimiter = normalizedDelimiter;
        return this;
    }

    public PathLexerBuilder setNormalizedArrayOpenTag(String normalizedArrayOpenTag) {
        this.normalizedArrayOpenTag = normalizedArrayOpenTag;
        return this;
    }

    public PathLexerBuilder setNormalizedArrayCloseTag(String normalizedArrayCloseTag) {
        this.normalizedArrayCloseTag = normalizedArrayCloseTag;
        return this;
    }

    public PathLexerBuilder setNormalizedMapTag(String normalizedMapTag) {
        this.normalizedMapTag = normalizedMapTag;
        return this;
    }

    public PathLexerBuilder setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public PathLexerBuilder setSentenceNormalizer(SentenceNormalizer sentenceNormalizer) {
        this.sentenceNormalizer = sentenceNormalizer;
        return this;
    }

    public PathLexerBuilder setPathPatternRegex(String pathPatternRegex) {
        this.pathPatternRegex = pathPatternRegex;
        return this;
    }

    public PathLexer build() {
        return new PathLexer(this.normalizedDelimiter, this.delimiter, this.pathPatternRegex, this.sentenceNormalizer, this.normalizedArrayOpenTag, this.normalizedArrayCloseTag, this.normalizedMapTag);
    }
}

