/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.lexer;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.PathUtil;

public abstract class SentenceLexer {
    public abstract String getNormalizedDeliminator();

    public abstract String getNormalizedArrayOpenTag();

    public abstract String getNormalizedArrayCloseTag();

    public abstract String getNormalizedMapTag();

    public abstract String getDeliminator();

    public abstract List<String> tokenizer(String var1);

    protected abstract GResultOf<List<Token>> evaluator(String var1, String var2);

    public abstract String normalizeSentence(String var1);

    public GResultOf<List<Token>> scan(String sentence) {
        if (sentence == null) {
            return GResultOf.errors(new ValidationError.EmptyPath());
        }
        if (sentence.isEmpty()) {
            return GResultOf.result(List.of());
        }
        List<String> tokenList = this.tokenizer(sentence);
        tokenList = tokenList.stream().map(this::normalizeSentence).collect(Collectors.toList());
        String dotPath = PathUtil.pathForKey(this, "", tokenList);
        List tokenWithValidations = tokenList.stream().map(word -> this.evaluator((String)word, dotPath)).collect(Collectors.toList());
        List tokens = tokenWithValidations.stream().filter(GResultOf::hasResults).map(GResultOf::results).flatMap(Collection::stream).collect(Collectors.toList());
        List<ValidationError> validations = tokenWithValidations.stream().filter(GResultOf::hasErrors).map(GResultOf::getErrors).flatMap(Collection::stream).collect(Collectors.toList());
        return GResultOf.resultOf(tokens, validations);
    }
}

