/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.github.gestalt.config.entity.ConfigValue;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.entity.ValidationLevel;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.parser.ConfigParser;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.Pair;

public final class ConfigCompiler {
    private ConfigCompiler() {
    }

    public static GResultOf<ConfigNode> analyze(boolean failOnErrors, SentenceLexer lexer, ConfigParser parser, List<Pair<String, String>> configs) {
        ArrayList<ValidationError> errorMessage = new ArrayList();
        List validatedTokens = configs.stream().map(prop -> new Pair<GResultOf<List<Token>>, String>(lexer.scan((String)prop.getFirst()), (String)prop.getSecond())).collect(Collectors.toList());
        Map<ValidationLevel, List<ValidationError>> validationErrors = validatedTokens.stream().filter(validatedToken -> ((GResultOf)validatedToken.getFirst()).hasErrors()).map(validatedToken -> ((GResultOf)validatedToken.getFirst()).getErrors()).flatMap(Collection::stream).collect(Collectors.groupingBy(ValidationError::level));
        if (!validationErrors.isEmpty()) {
            errorMessage = validationErrors.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            if (failOnErrors && validationErrors.containsKey((Object)ValidationLevel.ERROR)) {
                return GResultOf.errors(errorMessage);
            }
        }
        List<Pair<List<Token>, ConfigValue>> validTokens = validatedTokens.stream().filter(validatedToken -> !((GResultOf)validatedToken.getFirst()).hasErrors() && ((GResultOf)validatedToken.getFirst()).hasResults() && !((List)((GResultOf)validatedToken.getFirst()).results()).isEmpty()).map(validatedToken -> new Pair<List, ConfigValue>((List)((GResultOf)validatedToken.getFirst()).results(), new ConfigValue((String)validatedToken.getSecond()))).collect(Collectors.toList());
        GResultOf<ConfigNode> parserResults = parser.parse(lexer, validTokens, failOnErrors);
        errorMessage.addAll(parserResults.getErrors());
        return GResultOf.resultOf(parserResults.results(), errorMessage);
    }
}

