/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.github.gestalt.config.exceptions.GestaltConfigurationException;
import org.github.gestalt.config.loader.ConfigLoader;
import org.github.gestalt.config.loader.ConfigLoaderService;

public final class ConfigLoaderRegistry
implements ConfigLoaderService {
    private static final System.Logger logger = System.getLogger(ConfigLoaderRegistry.class.getName());
    private List<ConfigLoader> configLoaders = new ArrayList<ConfigLoader>();

    @Override
    public void addLoaders(List<ConfigLoader> configLoaders) {
        this.configLoaders.addAll(configLoaders);
    }

    @Override
    public void addLoader(ConfigLoader configLoader) {
        this.configLoaders.add(configLoader);
    }

    @Override
    public void setLoaders(List<ConfigLoader> configLoaders) {
        this.configLoaders = configLoaders;
    }

    @Override
    public List<ConfigLoader> getConfigLoaders() {
        return this.configLoaders;
    }

    @Override
    public ConfigLoader getLoader(String format) throws GestaltConfigurationException {
        List matchingConfig = this.configLoaders.stream().filter(config -> config.accepts(format)).collect(Collectors.toList());
        if (matchingConfig.isEmpty()) {
            throw new GestaltConfigurationException("Unable to find a config loader to match: " + format);
        }
        if (matchingConfig.size() > 1) {
            logger.log(System.Logger.Level.WARNING, "Found more than one configuration loaderFor format: {0}, found: {1}", format, matchingConfig);
        }
        return (ConfigLoader)matchingConfig.get(0);
    }
}

