/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.loader;

import java.util.ArrayList;
import java.util.List;
import org.github.gestalt.config.entity.ConfigNodeContainer;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.loader.ConfigLoader;
import org.github.gestalt.config.loader.ConfigLoaderService;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.source.ConfigSourcePackage;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;

public final class ConfigLoaderUtils {
    private ConfigLoaderUtils() {
    }

    public static GResultOf<List<ConfigNode>> convertSourceToNodes(ConfigSource source, ConfigLoaderService configLoaderService) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ArrayList<ConfigNode> configNodes = new ArrayList<ConfigNode>();
        try {
            ConfigLoader configLoader = configLoaderService.getLoader(source.format());
            GResultOf<List<ConfigNodeContainer>> loadedSource = configLoader.loadSource(new ConfigSourcePackage(source, List.of(), Tags.of()));
            errors.addAll(loadedSource.getErrors());
            if (loadedSource.hasResults()) {
                for (ConfigNodeContainer node : loadedSource.results()) {
                    configNodes.add(node.getConfigNode());
                }
            }
        }
        catch (GestaltException ex) {
            errors.add(new ValidationError.ConfigNodeImportException(ex));
            return GResultOf.errors(errors);
        }
        return GResultOf.resultOf(configNodes, errors);
    }
}

