/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.loader;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.github.gestalt.config.entity.ConfigNodeContainer;
import org.github.gestalt.config.entity.GestaltConfig;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.lexer.PathLexer;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.loader.ConfigCompiler;
import org.github.gestalt.config.loader.ConfigLoader;
import org.github.gestalt.config.loader.MapConfigLoaderModuleConfig;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.parser.ConfigParser;
import org.github.gestalt.config.parser.MapConfigParser;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.source.ConfigSourcePackage;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.Pair;

public final class MapConfigLoader
implements ConfigLoader {
    private ConfigParser parser;
    private SentenceLexer lexer;
    private final boolean isDefault;

    public MapConfigLoader() {
        this(new PathLexer(), new MapConfigParser(), true);
    }

    public MapConfigLoader(SentenceLexer lexer, ConfigParser parser) {
        this(lexer, parser, false);
    }

    private MapConfigLoader(SentenceLexer lexer, ConfigParser parser, boolean isDefault) {
        Objects.requireNonNull(lexer, "MapConfigLoader SentenceLexer should not be null");
        Objects.requireNonNull(parser, "MapConfigLoader ConfigParser should not be null");
        this.lexer = lexer;
        this.parser = parser;
        this.isDefault = isDefault;
    }

    @Override
    public void applyConfig(GestaltConfig config) {
        MapConfigLoaderModuleConfig moduleConfig = config.getModuleConfig(MapConfigLoaderModuleConfig.class);
        if (this.isDefault) {
            this.lexer = moduleConfig != null && moduleConfig.getLexer() != null ? moduleConfig.getLexer() : config.getSentenceLexer();
        }
        if (this.isDefault && moduleConfig != null && moduleConfig.getConfigParse() != null) {
            this.parser = moduleConfig.getConfigParse();
        }
    }

    @Override
    public String name() {
        return "MapConfigLoader";
    }

    @Override
    public boolean accepts(String format) {
        return "mapConfig".equals(format);
    }

    @Override
    public GResultOf<List<ConfigNodeContainer>> loadSource(ConfigSourcePackage sourcePackage) throws GestaltException {
        ConfigSource source = sourcePackage.getConfigSource();
        if (!source.hasList()) {
            throw new GestaltException("Config source: " + source.name() + " does not have a list to load.");
        }
        List<Pair<String, String>> configs = source.loadList();
        if (configs.isEmpty()) {
            return GResultOf.result(List.of(new ConfigNodeContainer(new MapNode(Map.of()), source, sourcePackage.getTags())));
        }
        GResultOf<ConfigNode> loadedNode = ConfigCompiler.analyze(source.failOnErrors(), this.lexer, this.parser, configs);
        return loadedNode.mapWithError(result -> List.of(new ConfigNodeContainer((ConfigNode)result, source, sourcePackage.getTags())));
    }
}

