/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.github.gestalt.config.entity.ConfigNodeContainer;
import org.github.gestalt.config.entity.GestaltConfig;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.lexer.PathLexer;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.loader.ConfigCompiler;
import org.github.gestalt.config.loader.ConfigLoader;
import org.github.gestalt.config.loader.PropertyLoaderModuleConfig;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.parser.ConfigParser;
import org.github.gestalt.config.parser.MapConfigParser;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.source.ConfigSourcePackage;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.Pair;

public final class PropertyLoader
implements ConfigLoader {
    private ConfigParser parser;
    private SentenceLexer lexer;
    private final boolean isDefault;

    public PropertyLoader() {
        this(new PathLexer(), new MapConfigParser(), true);
    }

    public PropertyLoader(SentenceLexer lexer, ConfigParser parser) {
        this(lexer, parser, false);
    }

    private PropertyLoader(SentenceLexer lexer, ConfigParser parser, boolean isDefault) {
        Objects.requireNonNull(lexer, "PropertyLoader SentenceLexer should not be null");
        Objects.requireNonNull(parser, "PropertyLoader ConfigParser should not be null");
        this.lexer = lexer;
        this.parser = parser;
        this.isDefault = isDefault;
    }

    @Override
    public void applyConfig(GestaltConfig config) {
        PropertyLoaderModuleConfig moduleConfig = config.getModuleConfig(PropertyLoaderModuleConfig.class);
        if (this.isDefault) {
            this.lexer = moduleConfig != null && moduleConfig.getLexer() != null ? moduleConfig.getLexer() : config.getSentenceLexer();
        }
        if (this.isDefault && moduleConfig != null && moduleConfig.getConfigParse() != null) {
            this.parser = moduleConfig.getConfigParse();
        }
    }

    @Override
    public String name() {
        return "PropertyLoader";
    }

    @Override
    public boolean accepts(String format) {
        return "properties".equals(format) || "props".equals(format) || "systemProperties".equals(format);
    }

    @Override
    public GResultOf<List<ConfigNodeContainer>> loadSource(ConfigSourcePackage sourcePackage) throws GestaltException {
        ConfigSource source;
        Properties properties;
        block10: {
            properties = new Properties();
            source = sourcePackage.getConfigSource();
            if (source.hasStream()) {
                try (InputStream is = source.loadStream();){
                    properties.load(is);
                    break block10;
                }
                catch (IOException | NullPointerException e) {
                    throw new GestaltException("Exception loading source: " + source.name(), e);
                }
            }
            throw new GestaltException("Config source: " + source.name() + " does not have a stream to load.");
        }
        if (properties.isEmpty()) {
            return GResultOf.result(List.of(new ConfigNodeContainer(new MapNode(Map.of()), source, sourcePackage.getTags())));
        }
        List<Pair<String, String>> configs = properties.entrySet().stream().map(prop -> new Pair<String, String>((String)prop.getKey(), (String)prop.getValue())).collect(Collectors.toList());
        GResultOf<ConfigNode> loadedNode = ConfigCompiler.analyze(source.failOnErrors(), this.lexer, this.parser, configs);
        return loadedNode.mapWithError(result -> List.of(new ConfigNodeContainer((ConfigNode)result, source, sourcePackage.getTags())));
    }
}

