/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.metadata.MetaDataValue;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.NodeType;
import org.github.gestalt.config.secret.rules.SecretConcealer;

public abstract class AbstractConfigNode
implements ConfigNode {
    protected final Map<String, List<MetaDataValue<?>>> metadata;

    public AbstractConfigNode(Map<String, List<MetaDataValue<?>>> metadata) {
        this.metadata = Map.copyOf(Objects.requireNonNullElse(metadata, Collections.emptyMap()));
    }

    @Override
    public abstract NodeType getNodeType();

    @Override
    public Optional<String> getValue() {
        return Optional.empty();
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public Optional<ConfigNode> getIndex(int index) {
        return Optional.empty();
    }

    @Override
    public Optional<ConfigNode> getKey(String key) {
        return Optional.empty();
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public List<MetaDataValue<?>> getMetadata(String key) {
        return this.metadata.getOrDefault(key, List.of());
    }

    @Override
    public Map<String, List<MetaDataValue<?>>> getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean hasMetadata(String key) {
        return this.metadata.containsKey(key);
    }

    @Override
    public abstract String printer(String var1, SecretConcealer var2, SentenceLexer var3);
}

