/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.github.gestalt.config.lexer.PathLexer;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.metadata.MetaDataValue;
import org.github.gestalt.config.node.AbstractConfigNode;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.NodeType;
import org.github.gestalt.config.secret.rules.SecretConcealer;
import org.github.gestalt.config.utils.PathUtil;

public final class ArrayNode
extends AbstractConfigNode {
    private final List<ConfigNode> values;

    public ArrayNode(List<ConfigNode> values) {
        this(values, Map.of());
    }

    public ArrayNode(List<ConfigNode> values, Map<String, List<MetaDataValue<?>>> metadata) {
        super(metadata);
        this.values = Collections.unmodifiableList(Objects.requireNonNullElse(values, Collections.emptyList()));
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARRAY;
    }

    @Override
    public Optional<ConfigNode> getIndex(int index) {
        if (this.values.size() > index) {
            return Optional.ofNullable(this.values.get(index));
        }
        return Optional.empty();
    }

    public List<ConfigNode> getArray() {
        return this.values;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Map<String, List<MetaDataValue<?>>> getRolledUpMetadata() {
        Map<String, List<MetaDataValue<?>>> rolledUpMetadata = new HashMap();
        for (ConfigNode configNode : this.values) {
            if (configNode == null) continue;
            Map<String, List<MetaDataValue<?>>> nodeMetadata = configNode.getRolledUpMetadata();
            for (Map.Entry<String, List<MetaDataValue<?>>> entry : nodeMetadata.entrySet()) {
                for (MetaDataValue<?> metadata : entry.getValue()) {
                    rolledUpMetadata = metadata.rollup(rolledUpMetadata);
                }
            }
        }
        for (Map.Entry entry : this.metadata.entrySet()) {
            for (MetaDataValue metadata : (List)entry.getValue()) {
                rolledUpMetadata = metadata.rollup(rolledUpMetadata);
            }
        }
        return rolledUpMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayNode)) {
            return false;
        }
        ArrayNode arrayNode = (ArrayNode)o;
        return Objects.equals(this.values, arrayNode.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public String toString() {
        return this.printer("", null, new PathLexer());
    }

    @Override
    public String printer(String path, SecretConcealer secretConcealer, SentenceLexer lexer) {
        return "ArrayNode{values=[" + IntStream.range(0, this.values.size()).mapToObj(n -> this.values.get(n).printer(PathUtil.pathForIndex(lexer, path, n), secretConcealer, lexer)).collect(Collectors.joining(", ")) + "]}";
    }
}

