/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.StampedLock;
import java.util.stream.Collectors;
import org.github.gestalt.config.entity.ConfigNodeContainer;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.lexer.PathLexer;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.node.ArrayNode;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.ConfigNodeService;
import org.github.gestalt.config.node.ConfigNodeTagResolutionStrategy;
import org.github.gestalt.config.node.EqualTagsWithDefaultTagResolutionStrategy;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.node.MergeNodes;
import org.github.gestalt.config.processor.config.ConfigNodeProcessorManager;
import org.github.gestalt.config.processor.config.ConfigNodeProcessorService;
import org.github.gestalt.config.secret.rules.SecretConcealer;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.token.ArrayToken;
import org.github.gestalt.config.token.ObjectToken;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.CollectionUtils;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.PathUtil;

public final class ConfigNodeManager
implements ConfigNodeService {
    private final List<ConfigNodeContainer> configNodes = new ArrayList<ConfigNodeContainer>();
    private final LinkedHashMap<Tags, ConfigNode> roots = new LinkedHashMap();
    private final StampedLock lock = new StampedLock();
    private final ConfigNodeTagResolutionStrategy configNodeTagResolutionStrategy;
    private final SentenceLexer lexer;
    private final ConfigNodeProcessorService configNodeProcessorService;

    public ConfigNodeManager() {
        this(new EqualTagsWithDefaultTagResolutionStrategy(), new ConfigNodeProcessorManager(List.of(), List.of(), new PathLexer()), new PathLexer());
    }

    public ConfigNodeManager(ConfigNodeTagResolutionStrategy configNodeTagResolutionStrategy, ConfigNodeProcessorService configNodeProcessorService, SentenceLexer lexer) {
        this.configNodeTagResolutionStrategy = configNodeTagResolutionStrategy;
        this.configNodeProcessorService = configNodeProcessorService;
        this.lexer = lexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GResultOf<ConfigNode> addNode(ConfigNodeContainer newNode) throws GestaltException {
        if (newNode == null) {
            throw new GestaltException("No node provided");
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        long stamp = this.lock.writeLock();
        try {
            this.configNodes.add(newNode);
            if (this.roots.isEmpty() || !this.roots.containsKey(newNode.getTags())) {
                this.roots.put(newNode.getTags(), newNode.getConfigNode());
            } else {
                ConfigNode rootForTokens = this.roots.get(newNode.getTags());
                GResultOf<ConfigNode> mergedNode = MergeNodes.mergeNodes("", this.lexer, rootForTokens, newNode.getConfigNode());
                if (mergedNode.hasResults()) {
                    this.roots.put(newNode.getTags(), mergedNode.results());
                }
                errors.addAll(mergedNode.getErrors());
            }
            errors.addAll(this.validateNode(this.roots.get(newNode.getTags())));
            errors = errors.stream().filter(CollectionUtils.distinctBy(ValidationError::description)).collect(Collectors.toList());
            GResultOf<ConfigNode> gResultOf = GResultOf.resultOf(this.roots.get(newNode.getTags()), errors);
            return gResultOf;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GResultOf<Boolean> processConfigNodes() throws GestaltException {
        long stamp = this.lock.readLock();
        try {
            boolean ppSuccessful = true;
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            for (Map.Entry<Tags, ConfigNode> entry : this.roots.entrySet()) {
                Tags tags = entry.getKey();
                ConfigNode root = entry.getValue();
                GResultOf<ConfigNode> results = this.configNodeProcessorService.processConfigNodes("", root);
                errors.addAll(results.getErrors());
                if (results.hasResults()) {
                    boolean tryUpgradeSuccess = false;
                    while (!tryUpgradeSuccess) {
                        long ws = this.lock.tryConvertToWriteLock(stamp);
                        if (ws != 0L) {
                            stamp = ws;
                            tryUpgradeSuccess = true;
                            this.roots.put(tags, results.results());
                            continue;
                        }
                        this.lock.unlockRead(stamp);
                        stamp = this.lock.writeLock();
                    }
                    continue;
                }
                ppSuccessful = false;
                errors.add(new ValidationError.NodePostProcessingNoResults());
            }
            GResultOf<Boolean> gResultOf = GResultOf.resultOf(Boolean.valueOf(ppSuccessful), errors);
            return gResultOf;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GResultOf<ConfigNode> reloadNode(ConfigNodeContainer reloadNode) throws GestaltException {
        ConfigNode newRoot = null;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (reloadNode == null) {
            throw new GestaltException("Null value provided for Node to be reloaded");
        }
        long stamp = this.lock.readLock();
        try {
            int index = 0;
            for (ConfigNodeContainer nodePair : this.configNodes) {
                ConfigNode currentNode = nodePair.getConfigNode();
                if (nodePair.getSource().equals(reloadNode.getSource())) {
                    this.configNodes.set(index, reloadNode);
                    currentNode = reloadNode.getConfigNode();
                }
                if (!nodePair.matchesTags(reloadNode.getTags())) continue;
                if (newRoot == null) {
                    newRoot = currentNode;
                } else {
                    GResultOf<ConfigNode> mergedNode = MergeNodes.mergeNodes("", this.lexer, newRoot, currentNode);
                    errors.addAll(mergedNode.getErrors());
                    if (mergedNode.hasResults()) {
                        newRoot = mergedNode.results();
                    } else {
                        errors.add(new ValidationError.NoResultsFoundForNode("", "reload node"));
                    }
                }
                ++index;
            }
            errors.addAll(this.validateNode(newRoot));
            errors = errors.stream().filter(CollectionUtils.distinctBy(ValidationError::description)).collect(Collectors.toList());
            boolean tryUpgradeSuccess = false;
            while (!tryUpgradeSuccess) {
                long ws = this.lock.tryConvertToWriteLock(stamp);
                if (ws != 0L) {
                    stamp = ws;
                    tryUpgradeSuccess = true;
                    this.roots.put(reloadNode.getTags(), newRoot);
                    continue;
                }
                this.lock.unlockRead(stamp);
                stamp = this.lock.writeLock();
            }
            GResultOf<ConfigNode> gResultOf = GResultOf.resultOf(newRoot, errors);
            return gResultOf;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    private List<ValidationError> validateNode(ConfigNode node) {
        return this.validateNode("", node);
    }

    private List<ValidationError> validateNode(String path, ConfigNode node) {
        if (node instanceof ArrayNode) {
            return this.validateArrayNode(path, (ArrayNode)node);
        }
        if (node instanceof MapNode) {
            return this.validateMapNode(path, (MapNode)node);
        }
        if (node instanceof LeafNode) {
            return this.validateLeafNode(path, (LeafNode)node);
        }
        return Collections.singletonList(new ValidationError.UnknownNodeType(path, node.getClass().getName()));
    }

    private List<ValidationError> validateArrayNode(String path, ArrayNode node) {
        int size = node.size();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (int i = 0; i < size; ++i) {
            Optional<ConfigNode> valueOptional = node.getIndex(i);
            if (valueOptional.isEmpty()) {
                errors.add(new ValidationError.ArrayMissingIndex(i, path));
                continue;
            }
            String nextPath = PathUtil.pathForIndex(this.lexer, path, i);
            errors.addAll(this.validateNode(nextPath, valueOptional.get()));
        }
        return errors;
    }

    private List<ValidationError> validateMapNode(String path, MapNode node) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        node.getMapNode().forEach((key, value) -> {
            if (key == null) {
                errors.add(new ValidationError.EmptyNodeNameProvided(path));
            } else if (value == null) {
                errors.add(new ValidationError.EmptyNodeValueProvided(path, (String)key));
            } else {
                String nextPath = PathUtil.pathForKey(this.lexer, path, key);
                errors.addAll(this.validateNode(nextPath, (ConfigNode)value));
            }
        });
        return errors;
    }

    private List<ValidationError> validateLeafNode(String path, LeafNode node) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (node == null) {
            errors.add(new ValidationError.LeafNodesIsNull(path));
        } else if (node.getValue().isEmpty()) {
            errors.add(new ValidationError.LeafNodesHaveNoValues(path));
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GResultOf<ConfigNode> navigateToNode(String path, List<Token> tokens, Tags tags) {
        long stamp = this.lock.tryOptimisticRead();
        GResultOf<ConfigNode> value = this.navigateToNodeInternal(path, tokens, tags);
        if (!this.lock.validate(stamp)) {
            stamp = this.lock.readLock();
            try {
                GResultOf<ConfigNode> gResultOf = this.navigateToNodeInternal(path, tokens, tags);
                return gResultOf;
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }
        return value;
    }

    private GResultOf<ConfigNode> navigateToNodeInternal(String path, List<Token> tokens, Tags tags) {
        List<GResultOf<ConfigNode>> rootNodes = this.configNodeTagResolutionStrategy.rootsToSearch(this.roots, tags);
        if (rootNodes.isEmpty()) {
            return GResultOf.errors(new ValidationError.NoResultsFoundForNode(path, MapNode.class, "navigating to node"));
        }
        if (rootNodes.size() == 1) {
            if (rootNodes.get(0).hasResults()) {
                return this.navigateToPathForNode(path, tokens, rootNodes.get(0).results());
            }
            return rootNodes.get(0);
        }
        GResultOf<ConfigNode> firstNode = this.navigateToPathForNode(path, tokens, rootNodes.get(0).results());
        return rootNodes.subList(1, rootNodes.size()).stream().reduce(firstNode, (partial, element) -> {
            if (element.hasResults()) {
                GResultOf<ConfigNode> currentNode = this.navigateToPathForNode(path, tokens, (ConfigNode)element.results());
                if (currentNode.hasResults() && partial != null && partial.hasResults()) {
                    return MergeNodes.mergeNodes(path, this.lexer, (ConfigNode)partial.results(), currentNode.results());
                }
                if (partial != null && partial.hasResults()) {
                    return partial;
                }
                if (currentNode.hasResults()) {
                    return currentNode;
                }
            }
            return partial;
        });
    }

    private GResultOf<ConfigNode> navigateToPathForNode(String path, List<Token> tokens, ConfigNode currentNode) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ConfigNode nextNode = currentNode;
        for (Token token : tokens) {
            GResultOf<ConfigNode> result = this.navigateToNextNode(path, token, nextNode);
            if (result.hasErrors()) {
                return GResultOf.errors(result.getErrors());
            }
            if (result.hasResults()) {
                nextNode = result.results();
                continue;
            }
            errors.add(new ValidationError.NoResultsFoundForNode(path, MapNode.class, "navigating to node"));
        }
        return GResultOf.resultOf(nextNode, errors);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public GResultOf<ConfigNode> navigateToNextNode(String path, Token token, ConfigNode currentNode) {
        ConfigNode node = currentNode;
        if (node == null) {
            return GResultOf.errors(new ValidationError.NullNodeForPath(path));
        }
        if (token == null) {
            return GResultOf.errors(new ValidationError.NullTokenForPath(path));
        }
        if (token instanceof ArrayToken) {
            if (!(node instanceof ArrayNode)) return GResultOf.errors(new ValidationError.MismatchedObjectNodeForPath(path, ArrayNode.class, node.getClass()));
            Optional<ConfigNode> nextNode = node.getIndex(((ArrayToken)token).getIndex());
            if (!nextNode.isPresent()) return GResultOf.errors(new ValidationError.NoResultsFoundForNode(path, token.getClass(), "navigating to next node"));
            node = nextNode.get();
            return GResultOf.result(node);
        } else {
            if (!(token instanceof ObjectToken)) return GResultOf.errors(new ValidationError.UnsupportedTokenType(path, token));
            if (!(node instanceof MapNode)) return GResultOf.errors(new ValidationError.MismatchedObjectNodeForPath(path, MapNode.class, node.getClass()));
            Optional<ConfigNode> nextNode = node.getKey(((ObjectToken)token).getName());
            if (!nextNode.isPresent()) return GResultOf.errors(new ValidationError.NoResultsFoundForNode(path, token.getClass(), "navigating to next node"));
            node = nextNode.get();
        }
        return GResultOf.result(node);
    }

    @Override
    public GResultOf<ConfigNode> navigateToNextNode(String path, List<Token> tokens, ConfigNode currentNode) {
        if (currentNode == null) {
            return GResultOf.errors(new ValidationError.NullNodeForPath(path));
        }
        if (tokens == null) {
            return GResultOf.errors(new ValidationError.NullTokenForPath(path));
        }
        ConfigNode node = currentNode;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (Token token : tokens) {
            GResultOf<ConfigNode> result = this.navigateToNextNode(path, token, node);
            if (result.hasErrors()) {
                return GResultOf.errors(result.getErrors());
            }
            if (result.hasResults()) {
                node = result.results();
                continue;
            }
            errors.add(new ValidationError.NoResultsFoundForNode(path, MapNode.class, "navigating to node"));
        }
        return GResultOf.resultOf(node, errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String debugPrintRoot(Tags tags, SecretConcealer secretConcealer) {
        long stamp = this.lock.readLock();
        try {
            String string = this.roots.get(tags).printer("", secretConcealer, this.lexer);
            return string;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String debugPrintRoot(SecretConcealer secretConcealer) {
        long stamp = this.lock.readLock();
        try {
            String string = this.roots.entrySet().stream().map(it -> "tags: " + it.getKey() + " = " + ((ConfigNode)it.getValue()).printer("", secretConcealer, this.lexer)).collect(Collectors.joining("\n"));
            return string;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }
}

