/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.github.gestalt.config.lexer.PathLexer;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.metadata.MetaDataValue;
import org.github.gestalt.config.node.AbstractConfigNode;
import org.github.gestalt.config.node.NodeType;
import org.github.gestalt.config.secret.rules.SecretConcealer;

public class LeafNode
extends AbstractConfigNode {
    private final String value;

    public LeafNode(String value) {
        this(value, Map.of());
    }

    public LeafNode(String value, Map<String, List<MetaDataValue<?>>> metadata) {
        super(metadata);
        this.value = value;
    }

    public LeafNode duplicate(String value) {
        return new LeafNode(value, this.metadata);
    }

    @Override
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    public Optional<String> getValueInternal() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.LEAF;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Map<String, List<MetaDataValue<?>>> getRolledUpMetadata() {
        if (this.metadata.isEmpty()) {
            return this.metadata;
        }
        Map<String, List<MetaDataValue<?>>> rolledUpMetadata = new HashMap();
        for (Map.Entry entries : this.metadata.entrySet()) {
            for (MetaDataValue metadata : (List)entries.getValue()) {
                rolledUpMetadata = metadata.rollup(rolledUpMetadata);
            }
        }
        return rolledUpMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LeafNode)) {
            return false;
        }
        LeafNode leafNode = (LeafNode)o;
        return Objects.equals(this.value, leafNode.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.printer("", null, new PathLexer());
    }

    @Override
    public String printer(String path, SecretConcealer secretConcealer, SentenceLexer lexer) {
        String nodeValue = this.value;
        if (secretConcealer != null) {
            nodeValue = secretConcealer.concealSecret(path, nodeValue, this.metadata);
        }
        return "LeafNode{value='" + nodeValue + "'}";
    }
}

