/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.github.gestalt.config.lexer.PathLexer;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.metadata.MetaDataValue;
import org.github.gestalt.config.node.AbstractConfigNode;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.NodeType;
import org.github.gestalt.config.secret.rules.SecretConcealer;
import org.github.gestalt.config.utils.PathUtil;

public final class MapNode
extends AbstractConfigNode {
    private final Map<String, ConfigNode> nodes;

    public MapNode(Map<String, ConfigNode> mapNode) {
        this(mapNode, Map.of());
    }

    public MapNode(Map<String, ConfigNode> mapNode, Map<String, List<MetaDataValue<?>>> metadata) {
        super(metadata);
        this.nodes = Collections.unmodifiableMap(Objects.requireNonNullElse(mapNode, Collections.emptyMap()));
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MAP;
    }

    @Override
    public Optional<ConfigNode> getKey(String key) {
        if (this.nodes.containsKey(key)) {
            return Optional.ofNullable(this.nodes.get(key));
        }
        return Optional.empty();
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public Map<String, List<MetaDataValue<?>>> getRolledUpMetadata() {
        Map<String, List<MetaDataValue<?>>> rolledUpMetadata = new HashMap();
        for (ConfigNode configNode : this.nodes.values()) {
            if (configNode == null) continue;
            Map<String, List<MetaDataValue<?>>> nodeMetadata = configNode.getRolledUpMetadata();
            for (Map.Entry<String, List<MetaDataValue<?>>> entry : nodeMetadata.entrySet()) {
                for (MetaDataValue<?> metadata : entry.getValue()) {
                    rolledUpMetadata = metadata.rollup(rolledUpMetadata);
                }
            }
        }
        for (Map.Entry entry : this.metadata.entrySet()) {
            for (MetaDataValue metadata : (List)entry.getValue()) {
                rolledUpMetadata = metadata.rollup(rolledUpMetadata);
            }
        }
        return rolledUpMetadata;
    }

    public Map<String, ConfigNode> getMapNode() {
        return this.nodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapNode)) {
            return false;
        }
        MapNode mapNode1 = (MapNode)o;
        return Objects.equals(this.nodes, mapNode1.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.nodes);
    }

    public String toString() {
        return this.printer("", null, new PathLexer());
    }

    @Override
    public String printer(String path, SecretConcealer secretConcealer, SentenceLexer lexer) {
        return "MapNode{" + this.nodes.entrySet().stream().map(it -> {
            StringBuilder printedNode = new StringBuilder().append((String)it.getKey()).append('=');
            if (it.getValue() != null) {
                printedNode.append(((ConfigNode)it.getValue()).printer(PathUtil.pathForKey(lexer, path, (String)it.getKey()), secretConcealer, lexer));
            } else {
                printedNode.append("'null'");
            }
            return printedNode.toString();
        }).collect(Collectors.joining(", ")) + "}";
    }
}

