/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.node.ArrayNode;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.PathUtil;

public final class MergeNodes {
    private MergeNodes() {
    }

    public static GResultOf<ConfigNode> mergeNodes(String path, SentenceLexer lexer, ConfigNode node1, ConfigNode node2) {
        if (node1.getClass() != node2.getClass()) {
            return GResultOf.errors(new ValidationError.UnableToMergeDifferentNodes(node1.getClass(), node2.getClass()));
        }
        if (node1 instanceof ArrayNode) {
            return MergeNodes.mergeArrayNodes(path, lexer, (ArrayNode)node1, (ArrayNode)node2);
        }
        if (node1 instanceof MapNode) {
            return MergeNodes.mergeMapNodes(path, lexer, (MapNode)node1, (MapNode)node2);
        }
        if (node1 instanceof LeafNode) {
            return MergeNodes.mergeLeafNodes(path, (LeafNode)node1, (LeafNode)node2);
        }
        return GResultOf.errors(new ValidationError.UnknownNodeType(path, node1.getClass().getName()));
    }

    private static GResultOf<ConfigNode> mergeArrayNodes(String path, SentenceLexer lexer, ArrayNode arrayNode1, ArrayNode arrayNode2) {
        int maxSize = Math.max(arrayNode1.size(), arrayNode2.size());
        ConfigNode[] values = new ConfigNode[maxSize];
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (int i = 0; i < maxSize; ++i) {
            Optional<ConfigNode> array1AtIndex = arrayNode1.getIndex(i);
            Optional<ConfigNode> array2AtIndex = arrayNode2.getIndex(i);
            if (array1AtIndex.isPresent() && array2AtIndex.isPresent()) {
                String nextPath = PathUtil.pathForIndex(lexer, path, i);
                GResultOf<ConfigNode> result = MergeNodes.mergeNodes(nextPath, lexer, array1AtIndex.get(), array2AtIndex.get());
                errors.addAll(result.getErrors());
                if (result.hasResults()) {
                    values[i] = result.results();
                    continue;
                }
                errors.add(new ValidationError.NoResultsFoundForNode(path, ArrayNode.class, "merging arrays"));
                continue;
            }
            if (array1AtIndex.isPresent()) {
                values[i] = array1AtIndex.get();
                continue;
            }
            if (array2AtIndex.isPresent()) {
                values[i] = array2AtIndex.get();
                continue;
            }
            errors.add(new ValidationError.ArrayMissingIndex(i, path));
        }
        ArrayNode results = new ArrayNode(Arrays.asList(values));
        return GResultOf.resultOf(results, errors);
    }

    private static GResultOf<ConfigNode> mergeMapNodes(String path, SentenceLexer lexer, MapNode mapNode1, MapNode mapNode2) {
        String key;
        HashMap<String, ConfigNode> mergedNode = new HashMap<String, ConfigNode>();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (Map.Entry<String, ConfigNode> entry : mapNode1.getMapNode().entrySet()) {
            key = entry.getKey();
            if (key == null) {
                errors.add(new ValidationError.EmptyNodeNameProvided(path));
                continue;
            }
            if (entry.getValue() == null) {
                errors.add(new ValidationError.EmptyNodeValueProvided(path, key));
                continue;
            }
            if (mapNode2.getKey(key).isPresent()) {
                String nextPath = PathUtil.pathForKey(lexer, path, key);
                GResultOf<ConfigNode> result = MergeNodes.mergeNodes(nextPath, lexer, entry.getValue(), mapNode2.getKey(key).get());
                errors.addAll(result.getErrors());
                if (result.hasResults()) {
                    mergedNode.putIfAbsent(key, result.results());
                    continue;
                }
                errors.add(new ValidationError.NoResultsFoundForNode(path, MapNode.class, "merging maps"));
                continue;
            }
            mergedNode.putIfAbsent(key, entry.getValue());
        }
        for (Map.Entry<String, ConfigNode> entry : mapNode2.getMapNode().entrySet()) {
            key = entry.getKey();
            if (key == null) {
                errors.add(new ValidationError.EmptyNodeNameProvided(path));
                continue;
            }
            if (entry.getValue() == null) {
                errors.add(new ValidationError.EmptyNodeValueProvided(path, key));
                continue;
            }
            mergedNode.putIfAbsent(entry.getKey(), entry.getValue());
        }
        return GResultOf.resultOf(new MapNode((Map<String, ConfigNode>)mergedNode), errors);
    }

    private static GResultOf<ConfigNode> mergeLeafNodes(String path, LeafNode node1, LeafNode node2) {
        if (node2.getValue().isPresent()) {
            return GResultOf.result(node2);
        }
        if (node1.getValue().isPresent()) {
            return GResultOf.result(node1);
        }
        return GResultOf.errors(new ValidationError.LeafNodesHaveNoValues(path));
    }
}

