/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.loader.ConfigLoaderService;
import org.github.gestalt.config.loader.ConfigLoaderUtils;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.factory.ConfigNodeFactory;
import org.github.gestalt.config.node.factory.ConfigNodeFactoryConfig;
import org.github.gestalt.config.source.ClassPathConfigSourceBuilder;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.utils.GResultOf;

public class ClassPathConfigNodeFactory
implements ConfigNodeFactory {
    public static final String SOURCE_TYPE = "classPath";
    public static final String PARAMETER_RESOURCE = "resource";
    private ConfigLoaderService configLoaderService;

    @Override
    public void applyConfig(ConfigNodeFactoryConfig config) {
        this.configLoaderService = config.getConfigLoaderService();
    }

    @Override
    public Boolean supportsType(String type) {
        return SOURCE_TYPE.equalsIgnoreCase(type);
    }

    @Override
    public GResultOf<List<ConfigNode>> build(Map<String, String> parameters) {
        ClassPathConfigSourceBuilder classPathConfigSourceBuilder = ClassPathConfigSourceBuilder.builder();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        try {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (PARAMETER_RESOURCE.equalsIgnoreCase(entry.getKey())) {
                    classPathConfigSourceBuilder.setResource(entry.getValue());
                    continue;
                }
                errors.add(new ValidationError.ConfigSourceFactoryUnknownParameter(SOURCE_TYPE, entry.getKey(), entry.getValue()));
            }
            ConfigSource source = classPathConfigSourceBuilder.build().getConfigSource();
            GResultOf<List<ConfigNode>> loadedNodes = ConfigLoaderUtils.convertSourceToNodes(source, this.configLoaderService);
            errors.addAll(loadedNodes.getErrors());
            return GResultOf.resultOf(loadedNodes.results(), errors);
        }
        catch (Exception ex) {
            errors.add(new ValidationError.ConfigSourceFactoryException(SOURCE_TYPE, ex));
            return GResultOf.errors(errors);
        }
    }
}

