/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.factory.ConfigNodeFactory;
import org.github.gestalt.config.node.factory.ConfigNodeFactoryService;
import org.github.gestalt.config.utils.GResultOf;

public class ConfigNodeFactoryManager
implements ConfigNodeFactoryService {
    public static final String SOURCE = "source";
    private final List<ConfigNodeFactory> configSourceFactories;

    public ConfigNodeFactoryManager(List<ConfigNodeFactory> configSourceFactories) {
        this.configSourceFactories = new ArrayList<ConfigNodeFactory>(configSourceFactories);
    }

    @Override
    public void addConfigSourceFactories(List<ConfigNodeFactory> configSourceFactories) {
        this.configSourceFactories.addAll(configSourceFactories);
    }

    @Override
    public GResultOf<List<ConfigNode>> build(Map<String, String> parameters) {
        Optional<Map.Entry> source = parameters.entrySet().stream().filter(entry -> SOURCE.equalsIgnoreCase((String)entry.getKey())).findFirst();
        if (source.isEmpty()) {
            return GResultOf.errors(new ValidationError.ConfigSourceFactoryNoSource(parameters));
        }
        String sourceName = (String)source.get().getValue();
        Optional<ConfigNodeFactory> factory = this.configSourceFactories.stream().filter(it -> it.supportsType(sourceName)).findFirst();
        if (factory.isEmpty()) {
            return GResultOf.errors(new ValidationError.ConfigSourceFactoryNotFound(sourceName));
        }
        Map<String, String> factoryParameters = parameters.entrySet().stream().filter(entry -> !SOURCE.equalsIgnoreCase((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return factory.get().build(factoryParameters);
    }
}

