/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.ConfigNodeService;
import org.github.gestalt.config.node.factory.ConfigNodeFactory;
import org.github.gestalt.config.node.factory.ConfigNodeFactoryConfig;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.GResultOf;

public class ConfigNodeImportFactory
implements ConfigNodeFactory {
    public static final String SOURCE_TYPE = "node";
    public static final String PARAMETER_RESOURCE = "path";
    private ConfigNodeService configNodeService;
    private SentenceLexer lexer;

    @Override
    public void applyConfig(ConfigNodeFactoryConfig config) {
        this.configNodeService = config.getConfigNodeService();
        this.lexer = config.getLexer();
    }

    @Override
    public Boolean supportsType(String type) {
        return SOURCE_TYPE.equalsIgnoreCase(type);
    }

    @Override
    public GResultOf<List<ConfigNode>> build(Map<String, String> parameters) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        String path = null;
        try {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (PARAMETER_RESOURCE.equalsIgnoreCase(entry.getKey())) {
                    path = entry.getValue();
                    continue;
                }
                errors.add(new ValidationError.ConfigSourceFactoryUnknownParameter(SOURCE_TYPE, entry.getKey(), entry.getValue()));
            }
            if (path == null) {
                errors.add(new ValidationError.ConfigNodeImportNodeEmpty(path));
                return GResultOf.errors(errors);
            }
            GResultOf<List<Token>> pathTokens = this.lexer.scan(path);
            if (!pathTokens.hasResults()) {
                errors.add(new ValidationError.ConfigNodeImportNodeEmpty(path));
                return GResultOf.errors(errors);
            }
            GResultOf<ConfigNode> foundNode = this.configNodeService.navigateToNode(path, pathTokens.results(), Tags.of());
            return foundNode.mapWithError(List::of);
        }
        catch (Exception ex) {
            errors.add(new ValidationError.ConfigSourceFactoryException(SOURCE_TYPE, ex));
            return GResultOf.errors(errors);
        }
    }
}

