/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.loader.ConfigLoaderService;
import org.github.gestalt.config.loader.ConfigLoaderUtils;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.factory.ConfigNodeFactory;
import org.github.gestalt.config.node.factory.ConfigNodeFactoryConfig;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.source.EnvironmentConfigSourceBuilder;
import org.github.gestalt.config.utils.GResultOf;

public class EnvVarsConfigNodeFactory
implements ConfigNodeFactory {
    public static final String SOURCE_TYPE = "env";
    public static final String PARAMETER_FAIL_ON_ERRORS = "failOnErrors";
    public static final String PARAMETER_PREFIX = "prefix";
    public static final String PARAMETER_IGNORE_CASE_ON_PREFIX = "ignoreCaseOnPrefix";
    public static final String PARAMETER_REMOVE_PREFIX = "removePrefix";
    private ConfigLoaderService configLoaderService;

    @Override
    public void applyConfig(ConfigNodeFactoryConfig config) {
        this.configLoaderService = config.getConfigLoaderService();
    }

    @Override
    public Boolean supportsType(String type) {
        return SOURCE_TYPE.equalsIgnoreCase(type);
    }

    @Override
    public GResultOf<List<ConfigNode>> build(Map<String, String> parameters) {
        EnvironmentConfigSourceBuilder envConfigSourceBuilder = EnvironmentConfigSourceBuilder.builder();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        try {
            block14: for (Map.Entry<String, String> entry : parameters.entrySet()) {
                switch (entry.getKey()) {
                    case "failOnErrors": {
                        envConfigSourceBuilder.setFailOnErrors(Boolean.parseBoolean(entry.getValue()));
                        continue block14;
                    }
                    case "prefix": {
                        envConfigSourceBuilder.setPrefix(entry.getValue());
                        continue block14;
                    }
                    case "ignoreCaseOnPrefix": {
                        envConfigSourceBuilder.setIgnoreCaseOnPrefix(Boolean.parseBoolean(entry.getValue()));
                        continue block14;
                    }
                    case "removePrefix": {
                        envConfigSourceBuilder.setRemovePrefix(Boolean.parseBoolean(entry.getValue()));
                        continue block14;
                    }
                }
                errors.add(new ValidationError.ConfigSourceFactoryUnknownParameter(SOURCE_TYPE, entry.getKey(), entry.getValue()));
            }
            ConfigSource envConfigSource = envConfigSourceBuilder.build().getConfigSource();
            GResultOf<List<ConfigNode>> loadedNodes = ConfigLoaderUtils.convertSourceToNodes(envConfigSource, this.configLoaderService);
            errors.addAll(loadedNodes.getErrors());
            return GResultOf.resultOf(loadedNodes.results(), errors);
        }
        catch (Exception ex) {
            errors.add(new ValidationError.ConfigSourceFactoryException(SOURCE_TYPE, ex));
            return GResultOf.errors(errors);
        }
    }
}

