/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node.factory;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.loader.ConfigLoaderService;
import org.github.gestalt.config.loader.ConfigLoaderUtils;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.factory.ConfigNodeFactory;
import org.github.gestalt.config.node.factory.ConfigNodeFactoryConfig;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.source.FileConfigSourceBuilder;
import org.github.gestalt.config.utils.GResultOf;

public class FileConfigNodeFactory
implements ConfigNodeFactory {
    public static final String SOURCE_TYPE = "file";
    public static final String PARAMETER_PATH = "path";
    public static final String PARAMETER_FILE = "file";
    private ConfigLoaderService configLoaderService;

    @Override
    public void applyConfig(ConfigNodeFactoryConfig config) {
        this.configLoaderService = config.getConfigLoaderService();
    }

    @Override
    public Boolean supportsType(String type) {
        return "file".equalsIgnoreCase(type);
    }

    @Override
    public GResultOf<List<ConfigNode>> build(Map<String, String> parameters) {
        FileConfigSourceBuilder fileConfigSourceBuilder = FileConfigSourceBuilder.builder();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        try {
            block10: for (Map.Entry<String, String> entry : parameters.entrySet()) {
                switch (entry.getKey()) {
                    case "path": {
                        fileConfigSourceBuilder.setPath(Path.of(entry.getValue(), new String[0]));
                        continue block10;
                    }
                    case "file": {
                        fileConfigSourceBuilder.setFile(new File(entry.getValue()));
                        continue block10;
                    }
                }
                errors.add(new ValidationError.ConfigSourceFactoryUnknownParameter("file", entry.getKey(), entry.getValue()));
            }
            ConfigSource fileConfigSource = fileConfigSourceBuilder.build().getConfigSource();
            GResultOf<List<ConfigNode>> loadedNodes = ConfigLoaderUtils.convertSourceToNodes(fileConfigSource, this.configLoaderService);
            errors.addAll(loadedNodes.getErrors());
            return GResultOf.resultOf(loadedNodes.results(), errors);
        }
        catch (Exception ex) {
            errors.add(new ValidationError.ConfigSourceFactoryException("file", ex));
            return GResultOf.errors(errors);
        }
    }
}

