/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node.factory;

import java.util.List;
import java.util.Map;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.loader.ConfigLoaderService;
import org.github.gestalt.config.loader.ConfigLoaderUtils;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.factory.ConfigNodeFactory;
import org.github.gestalt.config.node.factory.ConfigNodeFactoryConfig;
import org.github.gestalt.config.source.ConfigSourcePackage;
import org.github.gestalt.config.source.MapConfigSourceBuilder;
import org.github.gestalt.config.utils.GResultOf;

public class MapNodeImportFactory
implements ConfigNodeFactory {
    private final String source;
    private final Map<String, String> configMap;
    private ConfigLoaderService configLoaderService;

    public MapNodeImportFactory(String source, Map<String, String> configMap) {
        this.source = source;
        this.configMap = configMap;
    }

    @Override
    public void applyConfig(ConfigNodeFactoryConfig config) {
        this.configLoaderService = config.getConfigLoaderService();
    }

    @Override
    public Boolean supportsType(String type) {
        return type.equals(this.source);
    }

    @Override
    public GResultOf<List<ConfigNode>> build(Map<String, String> parameters) {
        try {
            ConfigSourcePackage mapConfigSource = MapConfigSourceBuilder.builder().setCustomConfig(this.configMap).build();
            return ConfigLoaderUtils.convertSourceToNodes(mapConfigSource.getConfigSource(), this.configLoaderService);
        }
        catch (GestaltException e) {
            return GResultOf.errors(new ValidationError.ConfigNodeImportException(e));
        }
    }
}

