/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.node.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.loader.ConfigLoaderService;
import org.github.gestalt.config.loader.ConfigLoaderUtils;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.factory.ConfigNodeFactory;
import org.github.gestalt.config.node.factory.ConfigNodeFactoryConfig;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.source.URLConfigSourceBuilder;
import org.github.gestalt.config.utils.GResultOf;

public class UrlConfigNodeFactory
implements ConfigNodeFactory {
    public static final String SOURCE_TYPE = "url";
    public static final String PARAMETER_URL = "url";
    private ConfigLoaderService configLoaderService;

    @Override
    public void applyConfig(ConfigNodeFactoryConfig config) {
        this.configLoaderService = config.getConfigLoaderService();
    }

    @Override
    public Boolean supportsType(String type) {
        return "url".equalsIgnoreCase(type);
    }

    @Override
    public GResultOf<List<ConfigNode>> build(Map<String, String> parameters) {
        URLConfigSourceBuilder urlConfigSourceBuilder = URLConfigSourceBuilder.builder();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        try {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if ("url".equals(entry.getKey())) {
                    urlConfigSourceBuilder.setSourceURL(entry.getValue());
                    continue;
                }
                errors.add(new ValidationError.ConfigSourceFactoryUnknownParameter("url", entry.getKey(), entry.getValue()));
            }
            ConfigSource urlConfigSource = urlConfigSourceBuilder.build().getConfigSource();
            GResultOf<List<ConfigNode>> loadedNodes = ConfigLoaderUtils.convertSourceToNodes(urlConfigSource, this.configLoaderService);
            errors.addAll(loadedNodes.getErrors());
            return GResultOf.resultOf(loadedNodes.results(), errors);
        }
        catch (Exception ex) {
            errors.add(new ValidationError.ConfigSourceFactoryException("url", ex));
            return GResultOf.errors(errors);
        }
    }
}

