/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.observations;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.github.gestalt.config.observations.ObservationMarker;
import org.github.gestalt.config.observations.ObservationRecord;
import org.github.gestalt.config.observations.ObservationRecorder;
import org.github.gestalt.config.observations.ObservationService;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.GResultOf;

public final class ObservationManager
implements ObservationService {
    private final Map<String, ObservationRecorder> observationRecorders;

    public ObservationManager(List<ObservationRecorder> recorder) {
        this.observationRecorders = recorder.stream().collect(Collectors.toMap(ObservationRecorder::recorderId, Function.identity()));
    }

    @Override
    public void addObservationRecorder(ObservationRecorder recorder) {
        Objects.requireNonNull(recorder, "ObservationRecorder should not be null");
        this.observationRecorders.put(recorder.recorderId(), recorder);
    }

    @Override
    public void addObservationRecorders(List<ObservationRecorder> recorder) {
        Objects.requireNonNull(recorder, "ObservationRecorder should not be null");
        recorder.forEach(it -> this.observationRecorders.put(it.recorderId(), (ObservationRecorder)it));
    }

    @Override
    public <T> ObservationMarker startGetConfig(String path, TypeCapture<T> klass, Tags tags, boolean isOptional) {
        Map<String, ObservationRecord> records = this.observationRecorders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> ((ObservationRecorder)it.getValue()).startGetConfig(path, klass, tags, isOptional)));
        return new ObservationMarker(records);
    }

    @Override
    public void finalizeGetConfig(ObservationMarker markers, Tags tags) {
        if (markers != null) {
            this.observationRecorders.forEach((key, value) -> value.finalizeObservation(markers.getObservationRecord((String)key), tags));
        }
    }

    @Override
    public ObservationMarker startObservation(String metric, Tags tags) {
        Map<String, ObservationRecord> records = this.observationRecorders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> ((ObservationRecorder)it.getValue()).startObservation(metric, tags)));
        return new ObservationMarker(records);
    }

    @Override
    public void finalizeObservation(ObservationMarker markers, Tags tags) {
        if (markers != null) {
            this.observationRecorders.forEach((key, value) -> value.finalizeObservation(markers.getObservationRecord((String)key), tags));
        }
    }

    @Override
    public void recordObservation(String observation, double count, Tags tags) {
        this.observationRecorders.forEach((key, value) -> value.recordObservation(observation, count, tags));
    }

    @Override
    public <T> void recordObservation(GResultOf<T> results, String path, TypeCapture<T> klass, Tags tags, boolean isOptional) {
        this.observationRecorders.forEach((key, value) -> value.recordObservation(results, path, klass, tags, isOptional));
    }
}

