/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.path.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.path.mapper.PathMapper;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.GResultOf;

@ConfigPriority(value=500)
public final class DotNotationPathMapper
implements PathMapper {
    private final Pattern regex = Pattern.compile("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");

    @Override
    public GResultOf<List<Token>> map(String path, String sentence, SentenceLexer lexer) {
        if (sentence == null || sentence.isEmpty()) {
            return GResultOf.errors(new ValidationError.MappingPathEmpty(path, "DotNotationPathMapper"));
        }
        String[] camelCaseWords = this.regex.split(sentence);
        ArrayList tokens = new ArrayList();
        for (String word : camelCaseWords) {
            GResultOf<List<Token>> lexedGResultOf = lexer.scan(word);
            if (lexedGResultOf.hasErrors()) {
                return GResultOf.errors(lexedGResultOf.getErrors());
            }
            if (!lexedGResultOf.hasResults()) {
                return GResultOf.errors(new ValidationError.NoResultsMappingPath(path, sentence, "dot notation path mapping"));
            }
            tokens.addAll(lexedGResultOf.results());
        }
        return GResultOf.result(tokens);
    }
}

