/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.processor.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.node.ArrayNode;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.processor.config.BaseConfigNodeProcessor;
import org.github.gestalt.config.processor.config.ConfigNodeProcessor;
import org.github.gestalt.config.processor.config.ConfigNodeProcessorService;
import org.github.gestalt.config.processor.config.RunTimeConfigNodeProcessor;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.PathUtil;

public final class ConfigNodeProcessorManager
implements ConfigNodeProcessorService {
    private final SentenceLexer lexer;
    private List<ConfigNodeProcessor> configNodeProcessors;
    private List<RunTimeConfigNodeProcessor> runTimeConfigNodeProcessors;

    public ConfigNodeProcessorManager(List<ConfigNodeProcessor> configNodeProcessors, List<RunTimeConfigNodeProcessor> runTimeConfigNodeProcessors, SentenceLexer lexer) {
        Objects.requireNonNull(lexer, "Lexer provided to the ConfigNodeProcessorManager should not be null");
        Objects.requireNonNull(configNodeProcessors, "configNodeProcessors provided to the ConfigNodeProcessorManager should not be null");
        this.lexer = lexer;
        this.configNodeProcessors = this.orderedConfigNodeProcessor(new ArrayList<ConfigNodeProcessor>(configNodeProcessors));
        this.runTimeConfigNodeProcessors = this.orderedConfigNodeProcessor(new ArrayList<RunTimeConfigNodeProcessor>(runTimeConfigNodeProcessors));
    }

    @Override
    public void addConfigNodeProcessors(List<ConfigNodeProcessor> configNodeProcessorsToAdd) {
        Objects.requireNonNull(this.configNodeProcessors, "configNodeProcessors added to the ConfigNodeProcessorManager should not be null");
        this.configNodeProcessors.addAll(configNodeProcessorsToAdd);
        this.configNodeProcessors = this.orderedConfigNodeProcessor(this.configNodeProcessors);
    }

    @Override
    public void addRuntimeConfigNodeProcessor(List<RunTimeConfigNodeProcessor> runTimeConfigNodeProcessor) {
        Objects.requireNonNull(runTimeConfigNodeProcessor, "runTimeConfigNodeProcessor added to the ConfigNodeProcessorManager should not be null");
        this.runTimeConfigNodeProcessors.addAll(runTimeConfigNodeProcessor);
        this.runTimeConfigNodeProcessors = this.orderedConfigNodeProcessor(runTimeConfigNodeProcessor);
    }

    private <T> List<T> orderedConfigNodeProcessor(List<T> processor) {
        return processor.stream().sorted((to, from) -> {
            ConfigPriority[] toAnnotation = (ConfigPriority[])to.getClass().getAnnotationsByType(ConfigPriority.class);
            int toValue = toAnnotation.length > 0 ? toAnnotation[0].value() : 1000;
            ConfigPriority[] fromAnnotation = (ConfigPriority[])from.getClass().getAnnotationsByType(ConfigPriority.class);
            int fromValue = fromAnnotation.length > 0 ? fromAnnotation[0].value() : 1000;
            return toValue - fromValue;
        }).collect(Collectors.toList());
    }

    @Override
    public GResultOf<ConfigNode> processConfigNodes(String path, ConfigNode node) {
        return this.commonProcessConfigNodes(path, node, this.configNodeProcessors, this::processConfigNodes);
    }

    @Override
    public GResultOf<ConfigNode> runTimeProcessConfigNodes(String path, ConfigNode node) {
        if (node == null) {
            return GResultOf.result(node);
        }
        return this.commonProcessConfigNodes(path, node, this.runTimeConfigNodeProcessors, this::runTimeProcessConfigNodes);
    }

    public <T extends BaseConfigNodeProcessor> GResultOf<ConfigNode> commonProcessConfigNodes(String path, ConfigNode node, List<T> processor, BiFunction<String, ConfigNode, GResultOf<ConfigNode>> processConfigNodes) {
        if (processor.isEmpty()) {
            return GResultOf.result(node);
        }
        ConfigNode currentNode = node;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (BaseConfigNodeProcessor it : processor) {
            GResultOf<ConfigNode> processedNode = it.process(path, currentNode);
            errors.addAll(processedNode.getErrors());
            if (processedNode.hasResults()) {
                currentNode = processedNode.results();
                continue;
            }
            errors.add(new ValidationError.NoResultsFoundForNode(path, node.getClass(), "post processing"));
        }
        if (currentNode instanceof ArrayNode) {
            return this.postProcessArray(path, (ArrayNode)currentNode, processConfigNodes);
        }
        if (currentNode instanceof MapNode) {
            return this.postProcessMap(path, (MapNode)currentNode, processConfigNodes);
        }
        if (currentNode instanceof LeafNode) {
            return GResultOf.resultOf(currentNode, errors);
        }
        return GResultOf.errors(new ValidationError.UnknownNodeTypePostProcess(path, node.getClass().getName()));
    }

    private GResultOf<ConfigNode> postProcessArray(String path, ArrayNode node, BiFunction<String, ConfigNode, GResultOf<ConfigNode>> processConfigNodes) {
        int size = node.size();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ConfigNode[] processedNode = new ConfigNode[size];
        for (int i = 0; i < size; ++i) {
            Optional<ConfigNode> currentNodeOption = node.getIndex(i);
            if (!currentNodeOption.isPresent()) continue;
            String nextPath = PathUtil.pathForIndex(this.lexer, path, i);
            GResultOf<ConfigNode> newNode = processConfigNodes.apply(nextPath, currentNodeOption.get());
            errors.addAll(newNode.getErrors());
            if (newNode.hasResults()) {
                processedNode[i] = newNode.results();
                continue;
            }
            errors.add(new ValidationError.NoResultsFoundForNode(path, ArrayNode.class, "post processing"));
        }
        return GResultOf.resultOf(new ArrayNode(Arrays.asList(processedNode)), errors);
    }

    private GResultOf<ConfigNode> postProcessMap(String path, MapNode node, BiFunction<String, ConfigNode, GResultOf<ConfigNode>> processConfigNodes) {
        HashMap<String, ConfigNode> processedNode = new HashMap<String, ConfigNode>();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (Map.Entry<String, ConfigNode> entry : node.getMapNode().entrySet()) {
            String key = entry.getKey();
            String nextPath = PathUtil.pathForKey(this.lexer, path, key);
            GResultOf<ConfigNode> newNode = processConfigNodes.apply(nextPath, entry.getValue());
            errors.addAll(newNode.getErrors());
            if (newNode.hasResults()) {
                processedNode.put(key, newNode.results());
                continue;
            }
            errors.add(new ValidationError.NoResultsFoundForNode(path, MapNode.class, "post processing"));
        }
        return GResultOf.resultOf(new MapNode((Map<String, ConfigNode>)processedNode), errors);
    }
}

