/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.processor.config.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.metadata.MetaDataValue;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.processor.config.ConfigNodeProcessor;
import org.github.gestalt.config.processor.config.ConfigNodeProcessorConfig;
import org.github.gestalt.config.processor.config.annotation.AnnotationMetadataTransform;
import org.github.gestalt.config.utils.GResultOf;

@ConfigPriority(value=100)
public class AnnotationConfigNodeProcessor
implements ConfigNodeProcessor {
    public static final String DEFAULT_ANNOTATION_REGEX = "^(?<annotation>\\w+)(:(?<parameter>.+?))?$";
    private final Map<String, AnnotationMetadataTransform> annotationMetadataTransforms = new HashMap<String, AnnotationMetadataTransform>();
    private String openingToken = "@{";
    private String closingToken = "}";
    private int openingTokenSize = this.openingToken.length();
    private int closingTokenSize = this.closingToken.length();
    private Pattern pattern = Pattern.compile("^(?<annotation>\\w+)(:(?<parameter>.+?))?$");
    private boolean annotationTrimWhiteSpace = true;

    public AnnotationConfigNodeProcessor() {
        ServiceLoader<AnnotationMetadataTransform> loader = ServiceLoader.load(AnnotationMetadataTransform.class);
        loader.forEach(it -> this.annotationMetadataTransforms.put(it.name(), (AnnotationMetadataTransform)it));
    }

    public AnnotationConfigNodeProcessor(List<AnnotationMetadataTransform> annotationMetadataList) {
        this.annotationMetadataTransforms.putAll(annotationMetadataList.stream().collect(Collectors.toMap(AnnotationMetadataTransform::name, Function.identity())));
    }

    @Override
    public void applyConfig(ConfigNodeProcessorConfig config) {
        this.openingToken = config.getConfig().getAnnotationOpeningToken();
        this.openingTokenSize = this.openingToken.length();
        this.closingToken = config.getConfig().getAnnotationClosingToken();
        this.closingTokenSize = this.closingToken.length();
        this.pattern = Pattern.compile(config.getConfig().getAnnotationRegex());
        this.annotationTrimWhiteSpace = config.getConfig().getAnnotationTrimWhiteSpace();
    }

    @Override
    public GResultOf<ConfigNode> process(String path, ConfigNode currentNode) {
        Optional<String> valueOptional = currentNode.getValue();
        if (!(currentNode instanceof LeafNode) || valueOptional.isEmpty() || valueOptional.get().isEmpty()) {
            return GResultOf.result(currentNode);
        }
        Object leafValue = valueOptional.get();
        int annotationLocation = ((String)leafValue).indexOf(this.openingToken);
        if (annotationLocation < 0) {
            return GResultOf.result(currentNode);
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        HashMap metadataMap = new HashMap();
        while (annotationLocation >= 0) {
            boolean foundAnnotation = false;
            int annotationClosing = ((String)leafValue).indexOf(this.closingToken, annotationLocation);
            if (annotationClosing > 0) {
                String annotation = ((String)leafValue).substring(annotationLocation + this.openingTokenSize, annotationClosing);
                Matcher matcher = this.pattern.matcher(annotation);
                if (!matcher.find()) {
                    errors.add(new ValidationError.FailedToExtractAnnotation(annotation, path));
                } else {
                    String annotationName = matcher.group("annotation");
                    String parameter = matcher.group("parameter");
                    if (this.annotationMetadataTransforms.containsKey(annotationName.toLowerCase(Locale.ROOT))) {
                        GResultOf<Map<String, List<MetaDataValue<?>>>> metadata = this.annotationMetadataTransforms.get(annotationName.toLowerCase(Locale.ROOT)).annotationTransform(annotationName, parameter);
                        errors.addAll(metadata.getErrors());
                        metadataMap.putAll(metadata.results());
                        leafValue = this.annotationTrimWhiteSpace ? ((String)leafValue).substring(0, annotationLocation).stripTrailing() + ((String)leafValue).substring(annotationClosing + this.closingTokenSize).stripLeading() : ((String)leafValue).substring(0, annotationLocation) + ((String)leafValue).substring(annotationClosing + this.closingTokenSize);
                        foundAnnotation = true;
                    } else {
                        errors.add(new ValidationError.UnknownAnnotation(path, annotation));
                    }
                }
                if (!foundAnnotation) {
                    annotationLocation += this.openingTokenSize;
                }
                annotationLocation = ((String)leafValue).indexOf(this.openingToken, annotationLocation);
                continue;
            }
            errors.add(new ValidationError.NoAnnotationClosingToken(path, (String)leafValue));
            break;
        }
        return GResultOf.resultOf(new LeafNode((String)leafValue, metadataMap), errors);
    }
}

