/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.processor.config.include;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.node.MergeNodes;
import org.github.gestalt.config.node.factory.ConfigNodeFactoryService;
import org.github.gestalt.config.processor.config.ConfigNodeProcessor;
import org.github.gestalt.config.processor.config.ConfigNodeProcessorConfig;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.Pair;
import org.github.gestalt.config.utils.StringUtils;

@ConfigPriority(value=500)
public class IncludeConfigNodeProcessor
implements ConfigNodeProcessor {
    private ConfigNodeFactoryService configNodeFactoryService;
    private String nodeImportKeyword;
    private SentenceLexer lexer;
    private Integer nodeNestedIncludeLimit;

    private List<Pair<Integer, ConfigNode>> buildOrderedIncludeNodes(String importKey, GResultOf<List<ConfigNode>> loadedConfigNode) {
        String[] importDetails = importKey.split(":");
        int order = importDetails.length > 1 && StringUtils.isInteger(importDetails[1]) ? Integer.parseInt(importDetails[1].trim()) : -1;
        return loadedConfigNode.results().stream().map(it -> new Pair<Integer, ConfigNode>(order, (ConfigNode)it)).collect(Collectors.toList());
    }

    private Map<String, String> convertStringToParameters(String path, String paramtersString, List<ValidationError> errors) {
        return Arrays.stream(paramtersString.split(",")).map(it -> {
            String[] parts = it.split("=");
            if (parts.length != 2 || parts[0].isEmpty() || parts[1].isEmpty()) {
                errors.add(new ValidationError.ConfigNodeImportParameterHasWrongSize(path, paramtersString, (String)it));
                return null;
            }
            return new Pair<String, String>(parts[0].trim(), parts[1].trim());
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    @Override
    public void applyConfig(ConfigNodeProcessorConfig config) {
        this.configNodeFactoryService = config.getConfigSourceFactoryService();
        this.nodeImportKeyword = config.getConfig().getNodeIncludeKeyword();
        this.lexer = config.getLexer();
        this.nodeNestedIncludeLimit = config.getConfig().getNodeNestedIncludeLimit();
    }

    @Override
    public GResultOf<ConfigNode> process(String path, ConfigNode currentNode) {
        return this.process(path, currentNode, 0);
    }

    private GResultOf<ConfigNode> process(String path, ConfigNode currentNode, Integer nestedLevel) {
        if (this.configNodeFactoryService == null || !(currentNode instanceof MapNode)) {
            return GResultOf.result(currentNode);
        }
        if (nestedLevel >= this.nodeNestedIncludeLimit) {
            return GResultOf.resultOf(currentNode, List.of(new ValidationError.ConfigNodeImportMaxNested(path, this.nodeNestedIncludeLimit)));
        }
        MapNode mapNode = (MapNode)currentNode;
        Map<String, ConfigNode> internalMap = mapNode.getMapNode();
        Map<String, ConfigNode> importingNodes = internalMap.entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null && ((String)entry.getKey()).startsWith(this.nodeImportKeyword)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (importingNodes.isEmpty()) {
            return GResultOf.result(currentNode);
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ArrayList<Pair<Integer, ConfigNode>> nodeAndOrderPair = new ArrayList<Pair<Integer, ConfigNode>>();
        HashMap<String, ConfigNode> originNodesNoImport = new HashMap<String, ConfigNode>(mapNode.getMapNode());
        for (Map.Entry<String, ConfigNode> includeEntries : importingNodes.entrySet()) {
            if (!(includeEntries.getValue() instanceof LeafNode)) {
                errors.add(new ValidationError.ConfigNodeImportWrongNodeType(path, includeEntries.getValue()));
                break;
            }
            LeafNode importLeafParameters = (LeafNode)includeEntries.getValue();
            if (importLeafParameters.getValue().isEmpty() || importLeafParameters.getValue().get().isEmpty()) {
                errors.add(new ValidationError.ConfigNodeImportNodeEmpty(path));
                break;
            }
            String paramtersString = importLeafParameters.getValue().get();
            Map<String, String> parameters = this.convertStringToParameters(path, paramtersString, errors);
            GResultOf<List<ConfigNode>> configNodesResult = this.configNodeFactoryService.build(parameters);
            errors.addAll(configNodesResult.getErrors());
            if (!configNodesResult.hasResults()) continue;
            List<Pair<Integer, ConfigNode>> orderedImportNodes = this.buildOrderedIncludeNodes(includeEntries.getKey(), configNodesResult);
            nodeAndOrderPair.addAll(orderedImportNodes);
            originNodesNoImport.remove(includeEntries.getKey());
        }
        nodeAndOrderPair.add(new Pair<Integer, MapNode>(0, new MapNode((Map<String, ConfigNode>)originNodesNoImport)));
        if (nodeAndOrderPair.size() <= 1) {
            return GResultOf.resultOf(new MapNode((Map<String, ConfigNode>)originNodesNoImport), errors);
        }
        ConfigNode mergedNode = this.mergeOrderedNodes(path, nodeAndOrderPair, errors);
        GResultOf<ConfigNode> nestedNodes = this.process(path, mergedNode, nestedLevel + 1);
        errors.addAll(nestedNodes.getErrors());
        if (nestedNodes.hasResults()) {
            return GResultOf.resultOf(nestedNodes.results(), errors);
        }
        return GResultOf.errors(errors);
    }

    private ConfigNode mergeOrderedNodes(String path, ArrayList<Pair<Integer, ConfigNode>> nodeAndOrderPair, List<ValidationError> errors) {
        List orderedNodesList = nodeAndOrderPair.stream().sorted(Comparator.comparingInt(Pair::getFirst)).map(Pair::getSecond).collect(Collectors.toList());
        ConfigNode mergedNode = (ConfigNode)orderedNodesList.get(0);
        if (orderedNodesList.size() > 1) {
            for (ConfigNode it : orderedNodesList.subList(1, orderedNodesList.size())) {
                GResultOf<ConfigNode> resultOfMerge = MergeNodes.mergeNodes(path, this.lexer, mergedNode, it);
                errors.addAll(resultOfMerge.getErrors());
                if (!resultOfMerge.hasResults()) continue;
                mergedNode = resultOfMerge.results();
            }
        }
        return mergedNode;
    }
}

