/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.processor.config.transform;

import java.nio.charset.Charset;
import java.util.Base64;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.processor.config.transform.Transformer;
import org.github.gestalt.config.utils.GResultOf;

public final class Base64DecoderTransformer
implements Transformer {
    @Override
    public String name() {
        return "base64Decode";
    }

    @Override
    public GResultOf<String> process(String path, String key, String rawValue) {
        if (key != null) {
            try {
                byte[] decodedBytes = Base64.getDecoder().decode(key);
                return GResultOf.result(new String(decodedBytes, Charset.defaultCharset()));
            }
            catch (IllegalArgumentException e) {
                return GResultOf.errors(new ValidationError.InvalidBase64DecodeString(path, key, e.getMessage()));
            }
        }
        return GResultOf.errors(new ValidationError.InvalidStringSubstitutionPostProcess(path, rawValue, this.name()));
    }
}

