/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.processor.config.transform;

import java.nio.charset.Charset;
import java.util.Base64;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.processor.config.transform.Transformer;
import org.github.gestalt.config.utils.GResultOf;

public final class Base64EncoderTransformer
implements Transformer {
    @Override
    public String name() {
        return "base64Encode";
    }

    @Override
    public GResultOf<String> process(String path, String key, String rawValue) {
        if (key != null) {
            String encodedBytes = Base64.getEncoder().encodeToString(key.getBytes(Charset.defaultCharset()));
            return GResultOf.result(encodedBytes);
        }
        return GResultOf.errors(new ValidationError.InvalidStringSubstitutionPostProcess(path, rawValue, this.name()));
    }
}

