/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.processor.config.transform;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.processor.config.transform.Transformer;
import org.github.gestalt.config.utils.GResultOf;

public final class ClasspathTransformer
implements Transformer {
    private final int prefixLength = (this.name() + ":").length();

    @Override
    public String name() {
        return "classpath";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GResultOf<String> process(String path, String key, String rawValue) {
        GResultOf<String> result;
        if (key != null) {
            InputStream is = null;
            try {
                String resource = rawValue.substring(this.prefixLength);
                is = this.getClass().getClassLoader().getResourceAsStream(resource);
                if (is == null && (is = ClasspathTransformer.class.getResourceAsStream(resource)) == null) {
                    GResultOf<String> gResultOf = GResultOf.errors(new ValidationError.ExceptionReadingFileDuringTransform(path, key, "Unable to load classpath resource from " + resource));
                    return gResultOf;
                }
                byte[] fileBytes = is.readAllBytes();
                result = GResultOf.result(new String(fileBytes, Charset.defaultCharset()));
            }
            catch (IOException e) {
                result = GResultOf.errors(new ValidationError.ExceptionReadingFileDuringTransform(path, key, e.getMessage()));
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        result = GResultOf.errors(new ValidationError.ExceptionReadingFileDuringTransform(path, key, e.getMessage()));
                    }
                }
            }
        } else {
            result = GResultOf.errors(new ValidationError.InvalidStringSubstitutionPostProcess(path, rawValue, this.name()));
        }
        return result;
    }
}

