/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.processor.config.transform;

import java.util.HashMap;
import java.util.Map;
import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.processor.config.transform.Transformer;
import org.github.gestalt.config.utils.GResultOf;

@ConfigPriority(value=400)
public final class CustomMapTransformer
implements Transformer {
    private final Map<String, String> replacementVars;

    public CustomMapTransformer() {
        this.replacementVars = new HashMap<String, String>();
    }

    public CustomMapTransformer(Map<String, String> replacementVars) {
        this.replacementVars = replacementVars;
    }

    @Override
    public String name() {
        return "map";
    }

    @Override
    public GResultOf<String> process(String path, String key, String rawValue) {
        if (this.replacementVars.containsKey(key)) {
            return GResultOf.result(this.replacementVars.get(key));
        }
        return GResultOf.errors(new ValidationError.NoCustomPropertyFoundPostProcess(path, key));
    }
}

