/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.processor.config.transform;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.processor.config.transform.Transformer;
import org.github.gestalt.config.utils.GResultOf;

public final class Distribution100Transformer
implements Transformer {
    private final Random random;

    public Distribution100Transformer() {
        this.random = new Random();
    }

    public Distribution100Transformer(long seed) {
        this.random = new Random(seed);
    }

    private GResultOf<List<Threshold>> parseConfig(String path, String config) {
        String[] parts = config.split(",");
        int numDefaults = 0;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ArrayList<Threshold> thresholds = new ArrayList<Threshold>();
        for (String part : parts) {
            if (part.contains(":")) {
                String[] pair = part.split(":");
                int limit = Integer.parseInt(pair[0].trim());
                String value = pair[1].trim();
                thresholds.add(new Threshold(limit, value));
                continue;
            }
            thresholds.add(new Threshold(Integer.MAX_VALUE, part.trim()));
            if (numDefaults++ < 1) continue;
            errors.add(new ValidationError.Dist100DuplicateDefaults(path, config));
        }
        thresholds.sort(Comparator.comparingInt(a -> a.limit));
        return GResultOf.resultOf(thresholds, errors);
    }

    @Override
    public String name() {
        return "dist100";
    }

    @Override
    public GResultOf<String> process(String path, String key, String rawValue) {
        if (key == null) {
            return GResultOf.errors(new ValidationError.InvalidStringSubstitutionPostProcess(path, key, this.name()));
        }
        GResultOf<List<Threshold>> thresholds = this.parseConfig(path, key);
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>(thresholds.getErrors());
        int randomInt = this.random.nextInt(100) + 1;
        GResultOf<String> outcome = this.determineOutcome(path, key, randomInt, thresholds.results());
        errors.addAll(outcome.getErrors());
        return GResultOf.resultOf(outcome.results(), errors);
    }

    private GResultOf<String> determineOutcome(String path, String key, int number, List<Threshold> thresholds) {
        for (Threshold threshold : thresholds) {
            if (number > threshold.limit) continue;
            return GResultOf.result(threshold.value);
        }
        return GResultOf.errors(new ValidationError.Dist100NoValueDetermined(path, key, number));
    }

    static class Threshold {
        int limit;
        String value;

        Threshold(int limit, String value) {
            this.limit = limit;
            this.value = value;
        }
    }
}

