/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.processor.config.transform;

import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.processor.config.transform.Transformer;
import org.github.gestalt.config.utils.GResultOf;

public final class FileTransformer
implements Transformer {
    private final int prefixLength = (this.name() + ":").length();

    @Override
    public String name() {
        return "file";
    }

    @Override
    public GResultOf<String> process(String path, String key, String rawValue) {
        if (key != null) {
            try {
                String filePath = rawValue.substring(this.prefixLength);
                return GResultOf.result(Files.readString(Path.of(filePath, new String[0]), Charset.defaultCharset()));
            }
            catch (Exception e) {
                return GResultOf.errors(new ValidationError.ExceptionReadingFileDuringTransform(path, key, e.getMessage()));
            }
        }
        return GResultOf.errors(new ValidationError.InvalidStringSubstitutionPostProcess(path, rawValue, this.name()));
    }
}

