/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.processor.config.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.entity.ValidationLevel;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.processor.config.ConfigNodeProcessorConfig;
import org.github.gestalt.config.processor.config.transform.Transformer;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.GResultOf;

@ConfigPriority(value=300)
public final class NodeTransformer
implements Transformer {
    private ConfigNodeProcessorConfig config;

    @Override
    public String name() {
        return "node";
    }

    @Override
    public void applyConfig(ConfigNodeProcessorConfig config) {
        this.config = config;
    }

    @Override
    public GResultOf<String> process(String path, String key, String rawValue) {
        if (this.config == null) {
            return GResultOf.errors(new ValidationError.NodePostProcessingConfigMissing(path, key));
        }
        if (key == null) {
            return GResultOf.errors(new ValidationError.InvalidStringSubstitutionPostProcess(path, rawValue, this.name()));
        }
        String normalizedPath = this.config.getLexer().normalizeSentence(key);
        GResultOf<List<Token>> resultsOf = this.config.getLexer().scan(normalizedPath);
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>(resultsOf.getErrors());
        if (resultsOf.hasErrors(ValidationLevel.ERROR)) {
            errors.add(new ValidationError.NodePostProcessingBadTokens(path, key));
            return GResultOf.errors(errors);
        }
        if (!resultsOf.hasResults()) {
            errors.add(new ValidationError.NodePostProcessingNoResultsForTokens(path, key));
            return GResultOf.errors(errors);
        }
        GResultOf<ConfigNode> resultOfConfigNode = this.config.getConfigNodeService().navigateToNode(path, resultsOf.results(), Tags.of());
        errors.addAll(resultOfConfigNode.getErrors());
        if (resultOfConfigNode.hasErrors(ValidationLevel.MISSING_VALUE)) {
            errors.add(new ValidationError.NodePostProcessingErrorsNavigatingToNode(path, key));
            return GResultOf.errors(errors);
        }
        if (!resultOfConfigNode.hasResults()) {
            errors.add(new ValidationError.NoResultsFoundForNode(path, key, "NodeTransformer"));
            return GResultOf.errors(errors);
        }
        ConfigNode node = resultOfConfigNode.results();
        if (!(node instanceof LeafNode)) {
            errors.add(new ValidationError.NodePostProcessingNodeNotLeaf(path, key));
            return GResultOf.errors(errors);
        }
        Optional<String> valueOptional = node.getValue();
        if (valueOptional.isEmpty()) {
            errors.add(new ValidationError.NodePostProcessingNodeLeafHasNoValue(path, key));
            return GResultOf.errors(errors);
        }
        return GResultOf.result(valueOptional.get());
    }
}

