/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.processor.config.transform;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.metadata.IsNoCacheMetadata;
import org.github.gestalt.config.metadata.IsRunTimeStringSubstitutionMetadata;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.processor.config.ConfigNodeProcessor;
import org.github.gestalt.config.processor.config.ConfigNodeProcessorConfig;
import org.github.gestalt.config.utils.GResultOf;

@ConfigPriority(value=100)
public final class RunTimeMetadataConfigNodeProcessor
implements ConfigNodeProcessor {
    private String openingToken = "#{";
    private String closingToken = "}";

    @Override
    public void applyConfig(ConfigNodeProcessorConfig config) {
        this.openingToken = config.getConfig().getRunTimeSubstitutionOpeningToken();
        this.closingToken = config.getConfig().getRunTimeSubstitutionClosingToken();
    }

    @Override
    public GResultOf<ConfigNode> process(String path, ConfigNode currentNode) {
        Optional<String> valueOptional = currentNode.getValue();
        if (!(currentNode instanceof LeafNode) || valueOptional.isEmpty() || valueOptional.get().isEmpty()) {
            return GResultOf.result(currentNode);
        }
        String leafValue = valueOptional.get();
        int runTimeStringSubLocation = leafValue.indexOf(this.openingToken);
        if (runTimeStringSubLocation < 0) {
            return GResultOf.result(currentNode);
        }
        int runTimeStringSubClosing = leafValue.indexOf(this.closingToken, runTimeStringSubLocation);
        HashMap metadataMap = new HashMap();
        if (runTimeStringSubClosing > runTimeStringSubLocation) {
            metadataMap.put(IsRunTimeStringSubstitutionMetadata.RUN_TIME_STRING_SUBSTITUTION, List.of(new IsRunTimeStringSubstitutionMetadata(true)));
            metadataMap.put(IsNoCacheMetadata.NO_CACHE, List.of(new IsNoCacheMetadata(true)));
        }
        return GResultOf.resultOf(new LeafNode(leafValue, metadataMap), List.of());
    }
}

