/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.processor.config.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.lexer.PathLexer;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.processor.config.ConfigNodeProcessorConfig;
import org.github.gestalt.config.processor.config.transform.Transformer;
import org.github.gestalt.config.processor.config.transform.substitution.SubstitutionNode;
import org.github.gestalt.config.processor.config.transform.substitution.SubstitutionTreeBuilder;
import org.github.gestalt.config.secret.rules.SecretConcealer;
import org.github.gestalt.config.utils.CollectionUtils;
import org.github.gestalt.config.utils.GResultOf;

public final class StringSubstitutionProcessor {
    public static final String DEFAULT_SUBSTITUTION_REGEX = "^((?<transform>\\w+):(?!=))?(?<key>.+?)(:=(?<default>.*))?$";
    private final Map<String, Transformer> transformers;
    private final List<Transformer> orderedDefaultTransformers;
    private final Pattern pattern;
    private final SubstitutionTreeBuilder substitutionTreeBuilder;
    private final SentenceLexer lexer;
    private final int maxRecursionDepth;
    private SecretConcealer secretConcealer;

    public StringSubstitutionProcessor(ConfigNodeProcessorConfig config, String openingToken, String closingToken) {
        this.transformers = new HashMap<String, Transformer>();
        ArrayList transformersList = new ArrayList();
        ServiceLoader<Transformer> loader = ServiceLoader.load(Transformer.class);
        loader.forEach(it -> {
            this.transformers.put(it.name(), (Transformer)it);
            transformersList.add(it);
        });
        this.orderedDefaultTransformers = CollectionUtils.buildOrderedConfigPriorities(transformersList, false);
        this.transformers.values().forEach(it -> it.applyConfig(config));
        this.substitutionTreeBuilder = new SubstitutionTreeBuilder(openingToken, closingToken);
        this.maxRecursionDepth = config.getConfig().getMaxSubstitutionNestedDepth();
        this.pattern = Pattern.compile(config.getConfig().getSubstitutionRegex());
        this.secretConcealer = config.getSecretConcealer();
        this.lexer = config.getLexer();
    }

    public StringSubstitutionProcessor(List<Transformer> transformers) {
        if (transformers == null) {
            this.transformers = Collections.emptyMap();
            this.orderedDefaultTransformers = List.of();
        } else {
            this.transformers = transformers.stream().collect(Collectors.toMap(Transformer::name, Function.identity()));
            this.orderedDefaultTransformers = CollectionUtils.buildOrderedConfigPriorities(transformers, false);
        }
        this.substitutionTreeBuilder = new SubstitutionTreeBuilder("${", "}");
        this.pattern = Pattern.compile(DEFAULT_SUBSTITUTION_REGEX);
        this.lexer = new PathLexer();
        this.maxRecursionDepth = 5;
    }

    public GResultOf<ConfigNode> process(String path, ConfigNode currentNode) {
        if (this.transformers.isEmpty() || !(currentNode instanceof LeafNode)) {
            return GResultOf.result(currentNode);
        }
        Optional<String> valueOptional = ((LeafNode)currentNode).getValueInternal();
        if (valueOptional.isEmpty()) {
            return GResultOf.result(currentNode);
        }
        String leafValue = valueOptional.get();
        GResultOf<List<SubstitutionNode>> substitutionNodes = this.substitutionTreeBuilder.build(path, leafValue);
        if (substitutionNodes.hasResults()) {
            GResultOf<String> results = this.buildSubstitutedStringList(path, currentNode, substitutionNodes.results(), 0);
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>(substitutionNodes.getErrors());
            errors.addAll(results.getErrors());
            GResultOf<String> combinedResultsWithError = GResultOf.resultOf(results.results(), errors);
            return combinedResultsWithError.mapWithError(it -> ((LeafNode)currentNode).duplicate((String)it));
        }
        return GResultOf.errors(substitutionNodes.getErrors());
    }

    private GResultOf<String> buildSubstitutedStringList(String path, ConfigNode originalNode, List<SubstitutionNode> nodes, int depth) {
        if (depth > this.maxRecursionDepth) {
            return GResultOf.errors(new ValidationError.ExceededMaximumNestedSubstitutionDepth(path, depth, originalNode, this.secretConcealer, this.lexer));
        }
        StringBuilder result = new StringBuilder();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (SubstitutionNode resolveNode : nodes) {
            if (resolveNode instanceof SubstitutionNode.TextNode) {
                result.append(((SubstitutionNode.TextNode)resolveNode).getText());
                continue;
            }
            if (resolveNode instanceof SubstitutionNode.TransformNode) {
                List<SubstitutionNode> nodes1 = ((SubstitutionNode.TransformNode)resolveNode).getSubNodes();
                GResultOf<String> recursiveResults = this.buildSubstitutedStringList(path, originalNode, nodes1, depth + 1);
                errors.addAll(recursiveResults.getErrors());
                if (!recursiveResults.hasResults()) continue;
                GResultOf<String> transformedString = this.transformString(path, recursiveResults.results());
                errors.addAll(transformedString.getErrors());
                if (!transformedString.hasResults()) continue;
                GResultOf<List<SubstitutionNode>> substitutionNodes = this.substitutionTreeBuilder.build(path, transformedString.results());
                errors.addAll(substitutionNodes.getErrors());
                if (!substitutionNodes.hasResults()) continue;
                GResultOf<String> nestedSub = this.buildSubstitutedStringList(path, originalNode, substitutionNodes.results(), depth + 1);
                errors.addAll(nestedSub.getErrors());
                if (!nestedSub.hasResults()) continue;
                result.append(nestedSub.results());
                continue;
            }
            errors.add(new ValidationError.NotAValidSubstitutionNode(path, resolveNode));
        }
        return GResultOf.resultOf(result.toString(), errors);
    }

    private GResultOf<String> transformString(String path, String input) {
        Matcher matcher = this.pattern.matcher(input);
        StringBuilder newLeafValue = new StringBuilder();
        boolean foundMatch = false;
        while (matcher.find()) {
            String transformName = matcher.group("transform");
            String key = matcher.group("key");
            String defaultValue = matcher.group("default");
            if (transformName != null) {
                if (this.transformers.containsKey(transformName)) {
                    GResultOf<String> transformValue = this.transformers.get(transformName).process(path, key, input);
                    if (transformValue.hasResults()) {
                        newLeafValue.append(transformValue.results());
                        foundMatch = true;
                        continue;
                    }
                    if (defaultValue != null) {
                        foundMatch = true;
                        newLeafValue.append(defaultValue);
                        continue;
                    }
                    if (transformValue.hasErrors()) {
                        return transformValue;
                    }
                    return GResultOf.errors(new ValidationError.NoKeyFoundForTransform(path, transformName, key));
                }
                return GResultOf.errors(new ValidationError.NoMatchingTransformFound(path, transformName));
            }
            boolean foundTransformer = false;
            for (Transformer transform : this.orderedDefaultTransformers) {
                GResultOf<String> transformValue = transform.process(path, key, input);
                if (!transformValue.hasResults()) continue;
                newLeafValue.append(transformValue.results());
                foundTransformer = true;
                foundMatch = true;
                break;
            }
            if (foundTransformer) continue;
            if (defaultValue != null) {
                foundMatch = true;
                newLeafValue.append(defaultValue);
                continue;
            }
            return GResultOf.errors(new ValidationError.NoMatchingDefaultTransformFound(path, key));
        }
        if (foundMatch) {
            return GResultOf.result(newLeafValue.toString());
        }
        return GResultOf.errors(new ValidationError.TransformDoesntMatchRegex(path, input));
    }
}

