/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.processor.config.transform;

import org.github.gestalt.config.annotations.ConfigPriority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.processor.config.transform.Transformer;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.SystemWrapper;

@ConfigPriority(value=200)
public final class SystemPropertiesTransformer
implements Transformer {
    @Override
    public String name() {
        return "sys";
    }

    @Override
    public GResultOf<String> process(String path, String key, String rawValue) {
        if (key == null) {
            return GResultOf.errors(new ValidationError.InvalidStringSubstitutionPostProcess(path, rawValue, this.name()));
        }
        if (!SystemWrapper.getProperties().containsKey(key)) {
            return GResultOf.errors(new ValidationError.NoSystemPropertyFoundPostProcess(path, key));
        }
        return GResultOf.result(SystemWrapper.getProperties().get(key).toString());
    }
}

