/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.processor.config.transform;

import java.net.URLDecoder;
import java.nio.charset.Charset;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.processor.config.transform.Transformer;
import org.github.gestalt.config.utils.GResultOf;

public final class URLDecoderTransformer
implements Transformer {
    @Override
    public String name() {
        return "urlDecode";
    }

    @Override
    public GResultOf<String> process(String path, String key, String rawValue) {
        if (key != null) {
            try {
                return GResultOf.result(URLDecoder.decode(key, Charset.defaultCharset()));
            }
            catch (IllegalArgumentException e) {
                return GResultOf.errors(new ValidationError.InvalidBase64DecodeString(path, key, e.getMessage()));
            }
        }
        return GResultOf.errors(new ValidationError.InvalidStringSubstitutionPostProcess(path, rawValue, this.name()));
    }
}

